use input_event_codes::*;

#[derive(Clone, Copy, Debug, Eq, PartialEq)]
#[repr(u16)]
pub enum KeyOrButton {
	KeyReserved = KEY_RESERVED,
	KeyEsc = KEY_ESC,
	Key1 = KEY_1,
	Key2 = KEY_2,
	Key3 = KEY_3,
	Key4 = KEY_4,
	Key5 = KEY_5,
	Key6 = KEY_6,
	Key7 = KEY_7,
	Key8 = KEY_8,
	Key9 = KEY_9,
	Key0 = KEY_0,
	KeyMinus = KEY_MINUS,
	KeyEqual = KEY_EQUAL,
	KeyBackspace = KEY_BACKSPACE,
	KeyTab = KEY_TAB,
	KeyQ = KEY_Q,
	KeyW = KEY_W,
	KeyE = KEY_E,
	KeyR = KEY_R,
	KeyT = KEY_T,
	KeyY = KEY_Y,
	KeyU = KEY_U,
	KeyI = KEY_I,
	KeyO = KEY_O,
	KeyP = KEY_P,
	KeyLeftBrace = KEY_LEFTBRACE,
	KeyRightBrace = KEY_RIGHTBRACE,
	KeyEnter = KEY_ENTER,
	KeyLeftCtrl = KEY_LEFTCTRL,
	KeyA = KEY_A,
	KeyS = KEY_S,
	KeyD = KEY_D,
	KeyF = KEY_F,
	KeyG = KEY_G,
	KeyH = KEY_H,
	KeyJ = KEY_J,
	KeyK = KEY_K,
	KeyL = KEY_L,
	KeySemicolon = KEY_SEMICOLON,
	KeyApostrophe = KEY_APOSTROPHE,
	KeyGrave = KEY_GRAVE,
	KeyLeftShift = KEY_LEFTSHIFT,
	KeyBackslash = KEY_BACKSLASH,
	KeyZ = KEY_Z,
	KeyX = KEY_X,
	KeyC = KEY_C,
	KeyV = KEY_V,
	KeyB = KEY_B,
	KeyN = KEY_N,
	KeyM = KEY_M,
	KeyComma = KEY_COMMA,
	KeyDot = KEY_DOT,
	KeySlash = KEY_SLASH,
	KeyRightShift = KEY_RIGHTSHIFT,
	KeyKPAsterisk = KEY_KPASTERISK,
	KeyLeftAlt = KEY_LEFTALT,
	KeySpace = KEY_SPACE,
	KeyCapsLock = KEY_CAPSLOCK,
	KeyF1 = KEY_F1,
	KeyF2 = KEY_F2,
	KeyF3 = KEY_F3,
	KeyF4 = KEY_F4,
	KeyF5 = KEY_F5,
	KeyF6 = KEY_F6,
	KeyF7 = KEY_F7,
	KeyF8 = KEY_F8,
	KeyF9 = KEY_F9,
	KeyF10 = KEY_F10,
	KeyNumLock = KEY_NUMLOCK,
	KeyScrollLock = KEY_SCROLLLOCK,
	KeyKP7 = KEY_KP7,
	KeyKP8 = KEY_KP8,
	KeyKP9 = KEY_KP9,
	KeyKPMinus = KEY_KPMINUS,
	KeyKP4 = KEY_KP4,
	KeyKP5 = KEY_KP5,
	KeyKP6 = KEY_KP6,
	KeyKPPlus = KEY_KPPLUS,
	KeyKP1 = KEY_KP1,
	KeyKP2 = KEY_KP2,
	KeyKP3 = KEY_KP3,
	KeyKP0 = KEY_KP0,
	KeyKPDot = KEY_KPDOT,
	Unknown054 = 0x054,
	KeyZenkakuHankaku = KEY_ZENKAKUHANKAKU,
	Key102ND = KEY_102ND,
	KeyF11 = KEY_F11,
	KeyF12 = KEY_F12,
	KeyRo = KEY_RO,
	KeyKatakana = KEY_KATAKANA,
	KeyHiragana = KEY_HIRAGANA,
	KeyHenkan = KEY_HENKAN,
	KeyKatakanaHiragana = KEY_KATAKANAHIRAGANA,
	KeyMuhenkan = KEY_MUHENKAN,
	KeyKPJpComma = KEY_KPJPCOMMA,
	KeyKPEnter = KEY_KPENTER,
	KeyRightCtrl = KEY_RIGHTCTRL,
	KeyKPSlash = KEY_KPSLASH,
	KeySysRq = KEY_SYSRQ,
	KeyRightAlt = KEY_RIGHTALT,
	KeyLinefeed = KEY_LINEFEED,
	KeyHome = KEY_HOME,
	KeyUp = KEY_UP,
	KeyPageUp = KEY_PAGEUP,
	KeyLeft = KEY_LEFT,
	KeyRight = KEY_RIGHT,
	KeyEnd = KEY_END,
	KeyDown = KEY_DOWN,
	KeyPageDown = KEY_PAGEDOWN,
	KeyInsert = KEY_INSERT,
	KeyDelete = KEY_DELETE,
	KeyMacro = KEY_MACRO,
	KeyMute = KEY_MUTE,
	KeyVolumeDown = KEY_VOLUMEDOWN,
	KeyVolumeUp = KEY_VOLUMEUP,
	KeyPower = KEY_POWER,
	KeyKPEqual = KEY_KPEQUAL,
	KeyKPPlusMinus = KEY_KPPLUSMINUS,
	KeyPause = KEY_PAUSE,
	KeyScale = KEY_SCALE,
	KeyKPComma = KEY_KPCOMMA,
	KeyHangeul = KEY_HANGEUL,
	//KeyHanguel = KEY_HANGUEL,
	KeyHanja = KEY_HANJA,
	KeyYen = KEY_YEN,
	KeyLeftMeta = KEY_LEFTMETA,
	KeyRightMeta = KEY_RIGHTMETA,
	KeyCompose = KEY_COMPOSE,
	KeyStop = KEY_STOP,
	KeyAgain = KEY_AGAIN,
	KeyProps = KEY_PROPS,
	KeyUndo = KEY_UNDO,
	KeyFront = KEY_FRONT,
	KeyCopy = KEY_COPY,
	KeyOpen = KEY_OPEN,
	KeyPaste = KEY_PASTE,
	KeyFind = KEY_FIND,
	KeyCut = KEY_CUT,
	KeyHelp = KEY_HELP,
	KeyMenu = KEY_MENU,
	KeyCalc = KEY_CALC,
	KeySetup = KEY_SETUP,
	KeySleep = KEY_SLEEP,
	KeyWakeup = KEY_WAKEUP,
	KeyFile = KEY_FILE,
	KeySendFile = KEY_SENDFILE,
	KeyDeleteFile = KEY_DELETEFILE,
	KeyXFER = KEY_XFER,
	KeyProgram1 = KEY_PROG1,
	KeyProgram2 = KEY_PROG2,
	KeyWWW = KEY_WWW,
	KeyMsDos = KEY_MSDOS,
	KeyCoffee = KEY_COFFEE,
	//KeyScreenLock = KEY_SCREENLOCK,
	KeyRotateDisplay = KEY_ROTATE_DISPLAY,
	//KeyDirection = KEY_DIRECTION,
	KeyCycleWindows = KEY_CYCLEWINDOWS,
	KeyMail = KEY_MAIL,
	KeyBookmarks = KEY_BOOKMARKS,
	KeyComputer = KEY_COMPUTER,
	KeyBack = KEY_BACK,
	KeyForward = KEY_FORWARD,
	KeyCloseCD = KEY_CLOSECD,
	KeyEjectCD = KEY_EJECTCD,
	KeyEjectCloseCD = KEY_EJECTCLOSECD,
	KeyNextSong = KEY_NEXTSONG,
	KeyPlayPause = KEY_PLAYPAUSE,
	KeyPreviousSong = KEY_PREVIOUSSONG,
	KeyStopCD = KEY_STOPCD,
	KeyRecord = KEY_RECORD,
	KeyRewind = KEY_REWIND,
	KeyPhone = KEY_PHONE,
	KeyIso = KEY_ISO,
	KeyConfig = KEY_CONFIG,
	KeyHomepage = KEY_HOMEPAGE,
	KeyRefresh = KEY_REFRESH,
	KeyExit = KEY_EXIT,
	KeyMove = KEY_MOVE,
	KeyEdit = KEY_EDIT,
	KeyScrollUp = KEY_SCROLLUP,
	KeyScrollDown = KEY_SCROLLDOWN,
	KeyKPLeftParen = KEY_KPLEFTPAREN,
	KeyKPRightParen = KEY_KPRIGHTPAREN,
	KeyNew = KEY_NEW,
	KeyRedo = KEY_REDO,
	KeyF13 = KEY_F13,
	KeyF14 = KEY_F14,
	KeyF15 = KEY_F15,
	KeyF16 = KEY_F16,
	KeyF17 = KEY_F17,
	KeyF18 = KEY_F18,
	KeyF19 = KEY_F19,
	KeyF20 = KEY_F20,
	KeyF21 = KEY_F21,
	KeyF22 = KEY_F22,
	KeyF23 = KEY_F23,
	KeyF24 = KEY_F24,
	Unknown0C3 = 0x0c3,
	Unknown0C4 = 0x0c4,
	Unknown0C5 = 0x0c5,
	Unknown0C6 = 0x0c6,
	Unknown0C7 = 0x0c7,
	KeyPlayCD = KEY_PLAYCD,
	KeyPauseCD = KEY_PAUSECD,
	KeyProgram3 = KEY_PROG3,
	KeyProgram4 = KEY_PROG4,
	KeyDashboard = KEY_DASHBOARD,
	KeySuspend = KEY_SUSPEND,
	KeyClose = KEY_CLOSE,
	KeyPlay = KEY_PLAY,
	KeyFastForward = KEY_FASTFORWARD,
	KeyBassBoost = KEY_BASSBOOST,
	KeyPrint = KEY_PRINT,
	KeyHP = KEY_HP,
	KeyCamera = KEY_CAMERA,
	KeySound = KEY_SOUND,
	KeyQuestion = KEY_QUESTION,
	KeyEmail = KEY_EMAIL,
	KeyChat = KEY_CHAT,
	KeySearch = KEY_SEARCH,
	KeyConnect = KEY_CONNECT,
	KeyFinance = KEY_FINANCE,
	KeySport = KEY_SPORT,
	KeyShop = KEY_SHOP,
	KeyAltErase = KEY_ALTERASE,
	KeyCancel = KEY_CANCEL,
	KeyBrightnessDown = KEY_BRIGHTNESSDOWN,
	KeyBrightnessUp = KEY_BRIGHTNESSUP,
	KeyMedia = KEY_MEDIA,
	KeySwitchVideoMode = KEY_SWITCHVIDEOMODE,
	KeyKeyboardIlluminationToggle = KEY_KBDILLUMTOGGLE,
	KeyKeyboardIlluminationDown = KEY_KBDILLUMDOWN,
	KeyKeyboardIlluminationUp = KEY_KBDILLUMUP,
	KeySend = KEY_SEND,
	KeyReply = KEY_REPLY,
	KeyForwardMail = KEY_FORWARDMAIL,
	KeySave = KEY_SAVE,
	KeyDocuments = KEY_DOCUMENTS,
	KeyBattery = KEY_BATTERY,
	KeyBluetooth = KEY_BLUETOOTH,
	KeyWLAN = KEY_WLAN,
	KeyUWB = KEY_UWB,
	KeyUnknown = KEY_UNKNOWN,
	KeyVideoNext = KEY_VIDEO_NEXT,
	KeyVideoPrev = KEY_VIDEO_PREV,
	KeyBrightnessCycle = KEY_BRIGHTNESS_CYCLE,
	KeyBrightnessAuto = KEY_BRIGHTNESS_AUTO,
	//KeyBrightnessZero = KEY_BRIGHTNESS_ZERO,
	KeyDisplayOff = KEY_DISPLAY_OFF,
	KeyWWAN = KEY_WWAN,
	//KeyWiMAX = KEY_WIMAX,
	KeyRFKill = KEY_RFKILL,
	KeyMicMute = KEY_MICMUTE,
	Unknown0F9 = 0x0f9,
	Unknown0FA = 0x0fa,
	Unknown0FB = 0x0fb,
	Unknown0FC = 0x0fc,
	Unknown0FD = 0x0fd,
	Unknown0FE = 0x0fe,
	Unknown0FF = 0x0ff,
	ButtonMisc = BTN_MISC,
	//Button0 = BTN_0,
	Button1 = BTN_1,
	Button2 = BTN_2,
	Button3 = BTN_3,
	Button4 = BTN_4,
	Button5 = BTN_5,
	Button6 = BTN_6,
	Button7 = BTN_7,
	Button8 = BTN_8,
	Button9 = BTN_9,
	Unknown10A = 0x10a,
	Unknown10B = 0x10b,
	Unknown10C = 0x10c,
	Unknown10D = 0x10d,
	Unknown10E = 0x10e,
	Unknown10F = 0x10f,
	//ButtonMouse = BTN_MOUSE,
	ButtonLeft = BTN_LEFT,
	ButtonRight = BTN_RIGHT,
	ButtonMiddle = BTN_MIDDLE,
	ButtonSide = BTN_SIDE,
	ButtonExtra = BTN_EXTRA,
	ButtonForward = BTN_FORWARD,
	ButtonBack = BTN_BACK,
	ButtonTask = BTN_TASK,
	Unknown118 = 0x118,
	Unknown119 = 0x119,
	Unknown11A = 0x11a,
	Unknown11B = 0x11b,
	Unknown11C = 0x11c,
	Unknown11D = 0x11d,
	Unknown11E = 0x11e,
	Unknown11F = 0x11f,
	//ButtonJoystick = BTN_JOYSTICK,
	ButtonTrigger = BTN_TRIGGER,
	ButtonThumb = BTN_THUMB,
	ButtonThumb2 = BTN_THUMB2,
	ButtonTop = BTN_TOP,
	ButtonTop2 = BTN_TOP2,
	ButtonPinkie = BTN_PINKIE,
	ButtonBase = BTN_BASE,
	ButtonBase2 = BTN_BASE2,
	ButtonBase3 = BTN_BASE3,
	ButtonBase4 = BTN_BASE4,
	ButtonBase5 = BTN_BASE5,
	ButtonBase6 = BTN_BASE6,
	Unknown12C = 0x12c,
	Unknown12D = 0x12d,
	Unknown12E = 0x12e,
	ButtonDead = BTN_DEAD,
	//ButtonGamepad = BTN_GAMEPAD,
	ButtonSouth = BTN_SOUTH,
	//ButtonA = BTN_A,
	ButtonEast = BTN_EAST,
	//ButtonB = BTN_B,
	ButtonC = BTN_C,
	ButtonNorth = BTN_NORTH,
	//ButtonX = BTN_X,
	ButtonWest = BTN_WEST,
	//ButtonY = BTN_Y,
	ButtonZ = BTN_Z,
	ButtonTriggerLeft = BTN_TL,
	ButtonTriggerRight = BTN_TR,
	ButtonTriggerLeft2 = BTN_TL2,
	ButtonTriggerRight2 = BTN_TR2,
	ButtonSelect = BTN_SELECT,
	ButtonStart = BTN_START,
	ButtonMode = BTN_MODE,
	ButtonThumbLeft = BTN_THUMBL,
	ButtonThumbRight = BTN_THUMBR,
	Unknown13F = 0x13f,
	//BUTTON_DIGI = BTN_DIGI,
	ButtonToolPen = BTN_TOOL_PEN,
	ButtonToolRubber = BTN_TOOL_RUBBER,
	ButtonToolBrush = BTN_TOOL_BRUSH,
	ButtonToolPencil = BTN_TOOL_PENCIL,
	ButtonToolAirbrush = BTN_TOOL_AIRBRUSH,
	ButtonToolFinger = BTN_TOOL_FINGER,
	ButtonToolMouse = BTN_TOOL_MOUSE,
	ButtonToolLens = BTN_TOOL_LENS,
	ButtonToolQuintTap = BTN_TOOL_QUINTTAP,
	ButtonStylus3 = BTN_STYLUS3,
	ButtonTouch = BTN_TOUCH,
	ButtonStylus = BTN_STYLUS,
	ButtonStylus2 = BTN_STYLUS2,
	ButtonToolDoubleTap = BTN_TOOL_DOUBLETAP,
	ButtonToolTripleTap = BTN_TOOL_TRIPLETAP,
	ButtonToolQuadTap = BTN_TOOL_QUADTAP,
	//ButtonWheel = BTN_WHEEL,
	ButtonGearDown = BTN_GEAR_DOWN,
	ButtonGearUp = BTN_GEAR_UP,
	Unknown152 = 0x152,
	Unknown153 = 0x153,
	Unknown154 = 0x154,
	Unknown155 = 0x155,
	Unknown156 = 0x156,
	Unknown157 = 0x157,
	Unknown158 = 0x158,
	Unknown159 = 0x159,
	Unknown15A = 0x15a,
	Unknown15B = 0x15b,
	Unknown15C = 0x15c,
	Unknown15D = 0x15d,
	Unknown15E = 0x15e,
	Unknown15F = 0x15f,
	KeyOk = KEY_OK,
	KeySelect = KEY_SELECT,
	KeyGoto = KEY_GOTO,
	KeyClear = KEY_CLEAR,
	KeyPower2 = KEY_POWER2,
	KeyOption = KEY_OPTION,
	KeyInfo = KEY_INFO,
	KeyTime = KEY_TIME,
	KeyVendor = KEY_VENDOR,
	KeyArchive = KEY_ARCHIVE,
	KeyProgram = KEY_PROGRAM,
	KeyChannel = KEY_CHANNEL,
	KeyFavorites = KEY_FAVORITES,
	KeyEPG = KEY_EPG,
	KeyPVR = KEY_PVR,
	KeyMHP = KEY_MHP,
	KeyLanguage = KEY_LANGUAGE,
	KeyTitle = KEY_TITLE,
	KeySubtitle = KEY_SUBTITLE,
	KeyAngle = KEY_ANGLE,
	KeyFullScreen = KEY_FULL_SCREEN,
	//KeyZoom = KEY_ZOOM,
	KeyMode = KEY_MODE,
	KeyKeyboard = KEY_KEYBOARD,
	KeyAspectRatio = KEY_ASPECT_RATIO,
	//KeyScreen = KEY_SCREEN,
	KeyPC = KEY_PC,
	KeyTV = KEY_TV,
	KeyTV2 = KEY_TV2,
	KeyVCR = KEY_VCR,
	KeyVCR2 = KEY_VCR2,
	KeySAT = KEY_SAT,
	KeySAT2 = KEY_SAT2,
	KeyCD = KEY_CD,
	KeyTape = KEY_TAPE,
	KeyRadio = KEY_RADIO,
	KeyTuner = KEY_TUNER,
	KeyPlayer = KEY_PLAYER,
	KeyText = KEY_TEXT,
	KeyDVD = KEY_DVD,
	KeyAux = KEY_AUX,
	KeyMP3 = KEY_MP3,
	KeyAudio = KEY_AUDIO,
	KeyVideo = KEY_VIDEO,
	KeyDirectory = KEY_DIRECTORY,
	KeyList = KEY_LIST,
	KeyMemo = KEY_MEMO,
	KeyCalendar = KEY_CALENDAR,
	KeyRed = KEY_RED,
	KeyGreen = KEY_GREEN,
	KeyYellow = KEY_YELLOW,
	KeyBlue = KEY_BLUE,
	KeyChannelUp = KEY_CHANNELUP,
	KeyChannelDown = KEY_CHANNELDOWN,
	KeyFirst = KEY_FIRST,
	KeyLast = KEY_LAST,
	KeyAb = KEY_AB,
	KeyNext = KEY_NEXT,
	KeyRestart = KEY_RESTART,
	KeySlow = KEY_SLOW,
	KeyShuffle = KEY_SHUFFLE,
	KeyBreak = KEY_BREAK,
	KeyPrevious = KEY_PREVIOUS,
	KeyDigits = KEY_DIGITS,
	KeyTeen = KEY_TEEN,
	KeyTwenty = KEY_TWEN,
	KeyVideophone = KEY_VIDEOPHONE,
	KeyGames = KEY_GAMES,
	KeyZoomIn = KEY_ZOOMIN,
	KeyZoomOut = KEY_ZOOMOUT,
	KeyZoomReset = KEY_ZOOMRESET,
	KeyWordProcessor = KEY_WORDPROCESSOR,
	KeyEditor = KEY_EDITOR,
	KeySpreadSheet = KEY_SPREADSHEET,
	KeyGraphicsEditor = KEY_GRAPHICSEDITOR,
	KeyPresentation = KEY_PRESENTATION,
	KeyDatabase = KEY_DATABASE,
	KeyNews = KEY_NEWS,
	KeyVoiceMail = KEY_VOICEMAIL,
	KeyAddressBook = KEY_ADDRESSBOOK,
	KeyMessenger = KEY_MESSENGER,
	KeyDisplayToggle = KEY_DISPLAYTOGGLE,
	//KeyBrightnessToggle = KEY_BRIGHTNESS_TOGGLE,
	KeySpellcheck = KEY_SPELLCHECK,
	KeyLogoff = KEY_LOGOFF,
	KeyDollar = KEY_DOLLAR,
	KeyEuro = KEY_EURO,
	KeyFrameBack = KEY_FRAMEBACK,
	KeyFrameForward = KEY_FRAMEFORWARD,
	KeyContextMenu = KEY_CONTEXT_MENU,
	KeyMediaRepeat = KEY_MEDIA_REPEAT,
	Key10ChannelsUp = KEY_10CHANNELSUP,
	Key10ChannelsDown = KEY_10CHANNELSDOWN,
	KeyImages = KEY_IMAGES,
	Unknown1BB = 0x1bb,
	Unknown1BC = 0x1bc,
	Unknown1BD = 0x1bd,
	Unknown1BE = 0x1be,
	Unknown1BF = 0x1bf,
	KeyDelEOL = KEY_DEL_EOL,
	KeyDelEOS = KEY_DEL_EOS,
	KeyInsLine = KEY_INS_LINE,
	KeyDelLine = KEY_DEL_LINE,
	Unknown1C4 = 0x1c4,
	Unknown1C5 = 0x1c5,
	Unknown1C6 = 0x1c6,
	Unknown1C7 = 0x1c7,
	Unknown1C8 = 0x1c8,
	Unknown1C9 = 0x1c9,
	Unknown1CA = 0x1ca,
	Unknown1CB = 0x1cb,
	Unknown1CC = 0x1cc,
	Unknown1CD = 0x1cd,
	Unknown1CE = 0x1ce,
	Unknown1CF = 0x1cf,
	KeyFn = KEY_FN,
	KeyFnEsc = KEY_FN_ESC,
	KeyFnF1 = KEY_FN_F1,
	KeyFnF2 = KEY_FN_F2,
	KeyFnF3 = KEY_FN_F3,
	KeyFnF4 = KEY_FN_F4,
	KeyFnF5 = KEY_FN_F5,
	KeyFnF6 = KEY_FN_F6,
	KeyFnF7 = KEY_FN_F7,
	KeyFnF8 = KEY_FN_F8,
	KeyFnF9 = KEY_FN_F9,
	KeyFnF10 = KEY_FN_F10,
	KeyFnF11 = KEY_FN_F11,
	KeyFnF12 = KEY_FN_F12,
	KeyFn1 = KEY_FN_1,
	KeyFn2 = KEY_FN_2,
	KeyFnD = KEY_FN_D,
	KeyFnE = KEY_FN_E,
	KeyFnF = KEY_FN_F,
	KeyFnS = KEY_FN_S,
	KeyFnB = KEY_FN_B,
	Unknown1E5 = 0x1e5,
	Unknown1E6 = 0x1e6,
	Unknown1E7 = 0x1e7,
	Unknown1E8 = 0x1e8,
	Unknown1E9 = 0x1e9,
	Unknown1EA = 0x1ea,
	Unknown1EB = 0x1eb,
	Unknown1EC = 0x1ec,
	Unknown1ED = 0x1ed,
	Unknown1EE = 0x1ee,
	Unknown1EF = 0x1ef,
	Unknown1F0 = 0x1f0,
	KeyBrailleDot1 = KEY_BRL_DOT1,
	KeyBrailleDot2 = KEY_BRL_DOT2,
	KeyBrailleDot3 = KEY_BRL_DOT3,
	KeyBrailleDot4 = KEY_BRL_DOT4,
	KeyBrailleDot5 = KEY_BRL_DOT5,
	KeyBrailleDot6 = KEY_BRL_DOT6,
	KeyBrailleDot7 = KEY_BRL_DOT7,
	KeyBrailleDot8 = KEY_BRL_DOT8,
	KeyBrailleDot9 = KEY_BRL_DOT9,
	KeyBrailleDot10 = KEY_BRL_DOT10,
	Unknown1FB = 0x1fb,
	Unknown1FC = 0x1fc,
	Unknown1FD = 0x1fd,
	Unknown1FE = 0x1fe,
	Unknown1FF = 0x1ff,
	KeyNumeric0 = KEY_NUMERIC_0,
	KeyNumeric1 = KEY_NUMERIC_1,
	KeyNumeric2 = KEY_NUMERIC_2,
	KeyNumeric3 = KEY_NUMERIC_3,
	KeyNumeric4 = KEY_NUMERIC_4,
	KeyNumeric5 = KEY_NUMERIC_5,
	KeyNumeric6 = KEY_NUMERIC_6,
	KeyNumeric7 = KEY_NUMERIC_7,
	KeyNumeric8 = KEY_NUMERIC_8,
	KeyNumeric9 = KEY_NUMERIC_9,
	KeyNumericStar = KEY_NUMERIC_STAR,
	KeyNumericPound = KEY_NUMERIC_POUND,
	KeyNumericA = KEY_NUMERIC_A,
	KeyNumericB = KEY_NUMERIC_B,
	KeyNumericC = KEY_NUMERIC_C,
	KeyNumericD = KEY_NUMERIC_D,
	KeyCameraFocus = KEY_CAMERA_FOCUS,
	KeyWPSButton = KEY_WPS_BUTTON,
	KeyTouchPadToggle = KEY_TOUCHPAD_TOGGLE,
	KeyTouchPadOn = KEY_TOUCHPAD_ON,
	KeyTouchPadOff = KEY_TOUCHPAD_OFF,
	KeyCameraZoomIn = KEY_CAMERA_ZOOMIN,
	KeyCameraZoomOut = KEY_CAMERA_ZOOMOUT,
	KeyCameraUp = KEY_CAMERA_UP,
	KeyCameraDown = KEY_CAMERA_DOWN,
	KeyCameraLeft = KEY_CAMERA_LEFT,
	KeyCameraRight = KEY_CAMERA_RIGHT,
	KeyAttendantOn = KEY_ATTENDANT_ON,
	KeyAttendantOff = KEY_ATTENDANT_OFF,
	KeyAttendantToggle = KEY_ATTENDANT_TOGGLE,
	KeyLightsToggle = KEY_LIGHTS_TOGGLE,
	Unknown21F = 0x21f,
	ButtonDpadUp = BTN_DPAD_UP,
	ButtonDpadDown = BTN_DPAD_DOWN,
	ButtonDpadLeft = BTN_DPAD_LEFT,
	ButtonDpadRight = BTN_DPAD_RIGHT,
	Unknown224 = 0x224,
	Unknown225 = 0x225,
	Unknown226 = 0x226,
	Unknown227 = 0x227,
	Unknown228 = 0x228,
	Unknown229 = 0x229,
	Unknown22A = 0x22a,
	Unknown22B = 0x22b,
	Unknown22C = 0x22c,
	Unknown22D = 0x22d,
	Unknown22E = 0x22e,
	Unknown22F = 0x22f,
	KeyALSToggle = KEY_ALS_TOGGLE,
	KeyRotateLockToggle = KEY_ROTATE_LOCK_TOGGLE,
	Unknown232 = 0x232,
	Unknown233 = 0x233,
	Unknown234 = 0x234,
	Unknown235 = 0x235,
	Unknown236 = 0x236,
	Unknown237 = 0x237,
	Unknown238 = 0x238,
	Unknown239 = 0x239,
	Unknown23A = 0x23a,
	Unknown23B = 0x23b,
	Unknown23C = 0x23c,
	Unknown23D = 0x23d,
	Unknown23E = 0x23e,
	Unknown23F = 0x23f,
	KeyButtonConfig = KEY_BUTTONCONFIG,
	KeyTaskManager = KEY_TASKMANAGER,
	KeyJournal = KEY_JOURNAL,
	KeyControlPanel = KEY_CONTROLPANEL,
	KeyAppSelect = KEY_APPSELECT,
	KeyScreenSaver = KEY_SCREENSAVER,
	KeyVoiceCommand = KEY_VOICECOMMAND,
	KeyAssistant = KEY_ASSISTANT,
	Unknown248 = 0x248,
	Unknown249 = 0x249,
	Unknown24A = 0x24a,
	Unknown24B = 0x24b,
	Unknown24C = 0x24c,
	Unknown24D = 0x24d,
	Unknown24E = 0x24e,
	Unknown24F = 0x24f,
	KeyBrightnessMin = KEY_BRIGHTNESS_MIN,
	KeyBrightnessMax = KEY_BRIGHTNESS_MAX,
	Unknown252 = 0x252,
	Unknown253 = 0x253,
	Unknown254 = 0x254,
	Unknown255 = 0x255,
	Unknown256 = 0x256,
	Unknown257 = 0x257,
	Unknown258 = 0x258,
	Unknown259 = 0x259,
	Unknown25A = 0x25a,
	Unknown25B = 0x25b,
	Unknown25C = 0x25c,
	Unknown25D = 0x25d,
	Unknown25E = 0x25e,
	Unknown25F = 0x25f,
	KeyKeyboardInputAssistPrevious = KEY_KBDINPUTASSIST_PREV,
	KeyKeyboardInputAssistNext = KEY_KBDINPUTASSIST_NEXT,
	KeyKeyboardInputAssistPreviousGroup = KEY_KBDINPUTASSIST_PREVGROUP,
	KeyKeyboardInputAssistNextGroup = KEY_KBDINPUTASSIST_NEXTGROUP,
	KeyKeyboardInputAssistAccept = KEY_KBDINPUTASSIST_ACCEPT,
	KeyKeyboardInputAssistCancel = KEY_KBDINPUTASSIST_CANCEL,
	KeyRightUp = KEY_RIGHT_UP,
	KeyRightDown = KEY_RIGHT_DOWN,
	KeyLeftUp = KEY_LEFT_UP,
	KeyLeftDown = KEY_LEFT_DOWN,
	KeyRootMenu = KEY_ROOT_MENU,
	KeyMediaTopMenu = KEY_MEDIA_TOP_MENU,
	KeyNumeric11 = KEY_NUMERIC_11,
	KeyNumeric12 = KEY_NUMERIC_12,
	KeyAudioDesc = KEY_AUDIO_DESC,
	Key3dMode = KEY_3D_MODE,
	KeyNextFavorite = KEY_NEXT_FAVORITE,
	KeyStopRecord = KEY_STOP_RECORD,
	KeyPauseRecord = KEY_PAUSE_RECORD,
	KeyVOD = KEY_VOD,
	KeyUnmute = KEY_UNMUTE,
	KeyFastReverse = KEY_FASTREVERSE,
	KeySlowReverse = KEY_SLOWREVERSE,
	KeyData = KEY_DATA,
	KeyOnscreenKeyboard = KEY_ONSCREEN_KEYBOARD,
	Unknown279 = 0x279,
	Unknown27A = 0x27a,
	Unknown27B = 0x27b,
	Unknown27C = 0x27c,
	Unknown27D = 0x27d,
	Unknown27E = 0x27e,
	Unknown27F = 0x27f,
	Unknown280 = 0x280,
	Unknown281 = 0x281,
	Unknown282 = 0x282,
	Unknown283 = 0x283,
	Unknown284 = 0x284,
	Unknown285 = 0x285,
	Unknown286 = 0x286,
	Unknown287 = 0x287,
	Unknown288 = 0x288,
	Unknown289 = 0x289,
	Unknown28A = 0x28a,
	Unknown28B = 0x28b,
	Unknown28C = 0x28c,
	Unknown28D = 0x28d,
	Unknown28E = 0x28e,
	Unknown28F = 0x28f,
	Unknown290 = 0x290,
	Unknown291 = 0x291,
	Unknown292 = 0x292,
	Unknown293 = 0x293,
	Unknown294 = 0x294,
	Unknown295 = 0x295,
	Unknown296 = 0x296,
	Unknown297 = 0x297,
	Unknown298 = 0x298,
	Unknown299 = 0x299,
	Unknown29A = 0x29a,
	Unknown29B = 0x29b,
	Unknown29C = 0x29c,
	Unknown29D = 0x29d,
	Unknown29E = 0x29e,
	Unknown29F = 0x29f,
	Unknown2A0 = 0x2a0,
	Unknown2A1 = 0x2a1,
	Unknown2A2 = 0x2a2,
	Unknown2A3 = 0x2a3,
	Unknown2A4 = 0x2a4,
	Unknown2A5 = 0x2a5,
	Unknown2A6 = 0x2a6,
	Unknown2A7 = 0x2a7,
	Unknown2A8 = 0x2a8,
	Unknown2A9 = 0x2a9,
	Unknown2AA = 0x2aa,
	Unknown2AB = 0x2ab,
	Unknown2AC = 0x2ac,
	Unknown2AD = 0x2ad,
	Unknown2AE = 0x2ae,
	Unknown2AF = 0x2af,
	Unknown2B0 = 0x2b0,
	Unknown2B1 = 0x2b1,
	Unknown2B2 = 0x2b2,
	Unknown2B3 = 0x2b3,
	Unknown2B4 = 0x2b4,
	Unknown2B5 = 0x2b5,
	Unknown2B6 = 0x2b6,
	Unknown2B7 = 0x2b7,
	Unknown2B8 = 0x2b8,
	Unknown2B9 = 0x2b9,
	Unknown2BA = 0x2ba,
	Unknown2BB = 0x2bb,
	Unknown2BC = 0x2bc,
	Unknown2BD = 0x2bd,
	Unknown2BE = 0x2be,
	Unknown2BF = 0x2bf,
	//ButtonTriggerHappy = BTN_TRIGGER_HAPPY,
	ButtonTriggerHappy1 = BTN_TRIGGER_HAPPY1,
	ButtonTriggerHappy2 = BTN_TRIGGER_HAPPY2,
	ButtonTriggerHappy3 = BTN_TRIGGER_HAPPY3,
	ButtonTriggerHappy4 = BTN_TRIGGER_HAPPY4,
	ButtonTriggerHappy5 = BTN_TRIGGER_HAPPY5,
	ButtonTriggerHappy6 = BTN_TRIGGER_HAPPY6,
	ButtonTriggerHappy7 = BTN_TRIGGER_HAPPY7,
	ButtonTriggerHappy8 = BTN_TRIGGER_HAPPY8,
	ButtonTriggerHappy9 = BTN_TRIGGER_HAPPY9,
	ButtonTriggerHappy10 = BTN_TRIGGER_HAPPY10,
	ButtonTriggerHappy11 = BTN_TRIGGER_HAPPY11,
	ButtonTriggerHappy12 = BTN_TRIGGER_HAPPY12,
	ButtonTriggerHappy13 = BTN_TRIGGER_HAPPY13,
	ButtonTriggerHappy14 = BTN_TRIGGER_HAPPY14,
	ButtonTriggerHappy15 = BTN_TRIGGER_HAPPY15,
	ButtonTriggerHappy16 = BTN_TRIGGER_HAPPY16,
	ButtonTriggerHappy17 = BTN_TRIGGER_HAPPY17,
	ButtonTriggerHappy18 = BTN_TRIGGER_HAPPY18,
	ButtonTriggerHappy19 = BTN_TRIGGER_HAPPY19,
	ButtonTriggerHappy20 = BTN_TRIGGER_HAPPY20,
	ButtonTriggerHappy21 = BTN_TRIGGER_HAPPY21,
	ButtonTriggerHappy22 = BTN_TRIGGER_HAPPY22,
	ButtonTriggerHappy23 = BTN_TRIGGER_HAPPY23,
	ButtonTriggerHappy24 = BTN_TRIGGER_HAPPY24,
	ButtonTriggerHappy25 = BTN_TRIGGER_HAPPY25,
	ButtonTriggerHappy26 = BTN_TRIGGER_HAPPY26,
	ButtonTriggerHappy27 = BTN_TRIGGER_HAPPY27,
	ButtonTriggerHappy28 = BTN_TRIGGER_HAPPY28,
	ButtonTriggerHappy29 = BTN_TRIGGER_HAPPY29,
	ButtonTriggerHappy30 = BTN_TRIGGER_HAPPY30,
	ButtonTriggerHappy31 = BTN_TRIGGER_HAPPY31,
	ButtonTriggerHappy32 = BTN_TRIGGER_HAPPY32,
	ButtonTriggerHappy33 = BTN_TRIGGER_HAPPY33,
	ButtonTriggerHappy34 = BTN_TRIGGER_HAPPY34,
	ButtonTriggerHappy35 = BTN_TRIGGER_HAPPY35,
	ButtonTriggerHappy36 = BTN_TRIGGER_HAPPY36,
	ButtonTriggerHappy37 = BTN_TRIGGER_HAPPY37,
	ButtonTriggerHappy38 = BTN_TRIGGER_HAPPY38,
	ButtonTriggerHappy39 = BTN_TRIGGER_HAPPY39,
	ButtonTriggerHappy40 = BTN_TRIGGER_HAPPY40,
	Unknown2E8 = 0x2e8,
	Unknown2E9 = 0x2e9,
	Unknown2EA = 0x2ea,
	Unknown2EB = 0x2eb,
	Unknown2EC = 0x2ec,
	Unknown2ED = 0x2ed,
	Unknown2EE = 0x2ee,
	Unknown2EF = 0x2ef,
	Unknown2F0 = 0x2f0,
	Unknown2F1 = 0x2f1,
	Unknown2F2 = 0x2f2,
	Unknown2F3 = 0x2f3,
	Unknown2F4 = 0x2f4,
	Unknown2F5 = 0x2f5,
	Unknown2F6 = 0x2f6,
	Unknown2F7 = 0x2f7,
	Unknown2F8 = 0x2f8,
	Unknown2F9 = 0x2f9,
	Unknown2FA = 0x2fa,
	Unknown2FB = 0x2fb,
	Unknown2FC = 0x2fc,
	Unknown2FD = 0x2fd,
	Unknown2FE = 0x2fe,
	//KeyMinInteresting = KEY_MIN_INTERESTING,
	Max = KEY_MAX,
	Cnt = KEY_CNT,
}

impl Default for KeyOrButton {
	fn default() -> Self {
		KeyOrButton::KeyReserved
	}
}
