#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
    }
}


extern crate hyper;
extern crate hyper_native_tls;

use hyper::Client;
use hyper::net::HttpsConnector;
use hyper_native_tls::NativeTlsClient;
use std::io::Read;
use std::net::Ipv4Addr;

// pub enum ResponseType {
//     Ipv4Addr,
//     Text,
//     Json,
//     Jsonp,
// }

//pub fn ipify(response_type: ResponseType) -> Ipv4Addr {
pub fn ipify() -> Ipv4Addr {
    // let format_value = match response_type {
    //     ResponseType::Ipv4Addr => "text",
    //     ResponseType::Text => "text",
    //     ResponseType::Json => "json",
    //     ResponseType::Jsonp => "jsonp",
    // };
    // let url = format!("https://api.ipify.org/?format={}", format_value);
    let url = format!("https://api.ipify.org/?format=text");

    let ssl = NativeTlsClient::new().unwrap();
    let connector = HttpsConnector::new(ssl);
    let client = Client::with_connector(connector);

    let mut resp = client.get(&url).send().unwrap();
    let mut body = vec![];
    resp.read_to_end(&mut body).unwrap();

    String::from_utf8_lossy(&body).parse::<Ipv4Addr>().unwrap()
}
