use crate::{repo, Repo, Result};
use bstr::BString;
use std::{
    ffi::CString,
    path::{Path, PathBuf},
};

#[derive(Debug, Clone)]
pub struct File(PathBuf);

impl File {
    pub fn new<P: Into<PathBuf>>(rel_path: P) -> Self {
        Self(rel_path.into())
    }

    pub fn rel_path(&self) -> &Path {
        self.0.as_path()
    }

    pub fn abs_path(&self, repo: &Repo) -> PathBuf {
        self.abs_path_internal(&repo.internal)
    }

    pub(crate) fn abs_path_internal(&self, repo: &repo::Internal) -> PathBuf {
        repo.path().join(self.rel_path())
    }

    /// Returns the relative path in the byte format libgit2 expects.
    pub(crate) fn rel_path_bytes(&self) -> Result<CString> {
        todo!("depends on unpublished");
        // Ok(git2::path_to_repo_path(self.rel_path())?)
    }
}

#[derive(Debug, Clone)]
pub struct Contents(BString);

impl Contents {
    pub fn new(contents: BString) -> Self {
        Self(contents)
    }

    pub(crate) fn buffer(&self) -> &[u8] {
        &*self.0
    }
}
