use ignore::overrides::OverrideBuilder;

pub fn add_vendor_override(mut builder: OverrideBuilder) -> OverrideBuilder {
    // Caches
    builder.add("!**/cache/**").unwrap();

    // Dependencies
    builder.add("!**/[Dd]ependencies/**").unwrap();

    // Distributions
    builder.add("!**/dist/**").unwrap();

    // C deps
    builder.add("!**/deps/**").unwrap();
    builder.add("!**/configure").unwrap();
    builder.add("!**/config.guess").unwrap();
    builder.add("!**/config.sub").unwrap();

    // stuff autogenerated by autoconf - still C deps
    builder.add("!**/aclocal.m4").unwrap();
    builder.add("!**/libtool.m4").unwrap();
    builder.add("!**/ltoptions.m4").unwrap();
    builder.add("!**/ltsugar.m4").unwrap();
    builder.add("!**/ltversion.m4").unwrap();
    builder.add("!**/lt~obsolete.m4").unwrap();

    // .NET Core Install Scripts
    builder.add("!**/dotnet-install.ps1").unwrap();
    builder.add("!**/dotnet-install.sh").unwrap();

    // Linters
    builder.add("!**/cpplint.py").unwrap();

    // Node dependencies
    builder.add("!**/node_modules/**").unwrap();

    // Yarn releases
    builder.add("!**/.yarn/releases/**").unwrap();

    // esy.sh dependencies
    builder.add("!**/_esy").unwrap();

    // Bower Components
    builder.add("!**/bower_components/**").unwrap();

    // Erlang bundles
    builder.add("!**/rebar/**").unwrap();
    builder.add("!**/erlang.mk").unwrap();

    // Go dependencies
    builder.add("!**/Godeps/_workspace/**").unwrap();

    // Go fixtures
    builder.add("!**/testdata/**").unwrap();

    // GNU indent profiles
    builder.add("!**/.indent.pro").unwrap();

    // Minified JavaScript and CSS
    builder.add("!**/*[.-]min.{css,js}").unwrap();

    // Stylesheets imported from packages
    builder.add("!**/*import.{css,less,scss,styl}").unwrap();

    // Bootstrap css and js
    builder
        .add("!**/bootstrap*.{js,css,less,scss,styl}")
        .unwrap();
    builder
        .add("!**/custom.bootstrap*.{js,css,less,scss,styl}")
        .unwrap();

    // Font Awesome
    builder
        .add("!**/font*awesome.{js,css,less,scss,styl}")
        .unwrap();
    builder
        .add("!**/font*awesome/**/*.{js,css,less,scss,styl}")
        .unwrap();

    // Foundation css
    builder.add("!**/foundation.{css,less,scss,styl}").unwrap();

    // Normalize.css
    builder.add("!**/normalize.{css,less,scss,styl}").unwrap();

    // Skeleton.css
    builder.add("!**/skeleton.{css,less,scss,styl}").unwrap();

    // Bourbon css
    builder.add("!**/[Bb]ourbon.{css,less,scss,styl}").unwrap();

    // Animate.css
    builder.add("!**/animate.{css,less,scss,styl}").unwrap();

    // Materialize.css
    builder
        .add("!**/materialize.{css,less,scss,styl,js}")
        .unwrap();

    // Select2
    builder.add("!**/select2/*.{css,scss,js}").unwrap();

    // Bulma css
    builder.add("!**/bulma.{css,sass,scss}").unwrap();

    // Vendored dependencies
    builder.add("!**/{3rd,[Tt]hird}*[Pp]arty/**").unwrap();
    builder.add("!**/vendor/**").unwrap();
    builder.add("!**/vendors/**").unwrap();
    builder.add("!**/external/**").unwrap();
    builder.add("!**/extern/**").unwrap();
    builder.add("!**/[Vv]endor/**").unwrap();

    // Debian packaging
    builder.add("!**/debian/**").unwrap();

    // Haxelib projects often contain a neko bytecode file named run.n
    builder.add("!**/run.n").unwrap();

    // Bootstrap Datepicker
    builder.add("!**/bootstrap-datepicker/**").unwrap();

    /* Commonly Bundled JavaScript frameworks */
    // jQuery
    builder.add("!**/jquery*.{js,css}").unwrap();

    // Fuel UX
    builder.add("!**/fuelux.js").unwrap();

    // bootboxjs
    builder.add("!**/bootbox.js").unwrap();

    // pdf-worker
    builder.add("!**/pdf.worker.js").unwrap();

    // Slick
    builder.add("!**/slick.*.js").unwrap();

    // Leaflet plugins
    builder.add("!**/Leaflet.Coordinates*.src.js").unwrap();
    builder.add("!**/leaflet.draw-src.js").unwrap();
    builder.add("!**/leaflet.draw.css").unwrap();
    builder.add("!**/Control.FullScreen.{css,js}").unwrap();
    builder.add("!**/leaflet.spin.js").unwrap();
    builder.add("!**/wicket-leaflet.js").unwrap();

    // Sublime Text workspace files
    builder.add("!**/.sublime-project").unwrap();
    builder.add("!**/.sublime-workspace").unwrap();

    // VS Code workspace files
    builder.add("!**/.vscode").unwrap();

    // Prototype
    builder.add("!**/prototype*.js").unwrap();
    builder.add("!**/effects.js").unwrap();
    builder.add("!**/controls.js").unwrap();
    builder.add("!**/dragdrop.js").unwrap();

    // Typescript definition files
    builder.add("!**/*.d.ts").unwrap();

    // MooTools
    builder.add("!**/mootools*.js").unwrap();

    // Dojo
    builder.add("!**/dojo.js").unwrap();

    // MochiKit
    builder.add("!**/MochiKit.js").unwrap();

    // YUI
    builder.add("!**/yahoo-*.js").unwrap();
    builder.add("!**/yui*.js").unwrap();

    // WYS editors
    builder.add("!**/ckeditor.js").unwrap();
    builder.add("!**/tiny_mce*.js").unwrap();
    builder
        .add("!**/tiny_mce/{langs,plugins,themes,utils}/**")
        .unwrap();

    // Ace Editor
    builder.add("!**/ace-build/**").unwrap();

    // Fontello CSS files
    builder.add("!**/fontello*.css").unwrap();

    // MathJax
    builder.add("!**/MathJax/**").unwrap();

    // Chart.js
    builder.add("!**/Chart.js").unwrap();

    // CodeMirror
    builder
        .add("!**/[Cc]ode[Mm]irror/*{lib,mode,theme,addon,keymap,demo}/**")
        .unwrap();

    // SyntaxHighlighter - http://alexgorbatchev.com/
    builder.add("!**/shBrush*.js").unwrap();
    builder.add("!**/shCore.js").unwrap();
    builder.add("!**/shLegacy.js").unwrap();

    // AngularJS
    builder.add("!**/angular*.js").unwrap();

    // D3.js
    builder.add("!**/d3*.js").unwrap();

    // React
    builder.add("!**/react*.js").unwrap();

    // flow-typed
    builder.add("!**/flow-typed/*.js").unwrap();

    // Modernizr
    builder.add("!**/modernizr*.js").unwrap();

    // Knockout
    builder.add("!**/knockout-*.js").unwrap();

    /* Python */

    // Sphinx
    builder
        .add("!**/{doc,docs}/{build,themes,theme,templates,template,static}")
        .unwrap();
    builder
        .add("!**/{doc,docs}/{build,themes,theme,templates,template,static}")
        .unwrap();

    // django
    builder.add("!**/admin_media/**").unwrap();
    builder.add("!**/env/**").unwrap();

    // Fabric
    builder.add("!**/fabfile.py").unwrap();

    // WAF
    builder.add("!**/waf").unwrap();

    // .osx
    builder.add("!**/.osx").unwrap();

    /* Obj-C */

    // Xcode
    builder.add("!**/.xctemplate/**").unwrap();
    builder.add("!**/.imageset/**").unwrap();

    // Carthage
    builder.add("!**/Carthage/**").unwrap();

    // Sparkle
    builder.add("!**/Sparkle/**").unwrap();

    // Crashlytics
    builder.add("!**/Crashlytics.framework/**").unwrap();

    // Fabric
    builder.add("!**/Fabric.framework/**").unwrap();

    // BuddyBuild
    builder.add("!**/BuddyBuildSDK.framework/**").unwrap();

    // Realm
    builder.add("!**/Realm.framework").unwrap();

    // RealmSwift
    builder.add("!**/RealmSwift.framework").unwrap();

    // git config files
    builder.add("!**/.gitattributes").unwrap();
    builder.add("!**/.gitignore").unwrap();
    builder.add("!**/.gitmodules").unwrap();

    /* Groovy */

    // Gradle
    builder.add("!**/gradlew").unwrap();
    builder.add("!**/gradlew.bat").unwrap();
    builder.add("!**/gradle/wrapper/**").unwrap();

    /* Java */

    // Maven
    builder.add("!**/mvnw").unwrap();
    builder.add("!**/mvnw.cmd").unwrap();
    builder.add("!**/.mvn/wrapper/**").unwrap();

    /* .NET */

    // Visual Studio IntelliSense
    builder.add("!**/*-vsdoc.js").unwrap();
    builder.add("!**/*.intellisense.js").unwrap();

    // jQuery validation plugin (MS bundles this with asp.net mvc)
    builder.add("!**/jquery*.validate*.js").unwrap();
    builder.add("!**/jquery*.unobtrusive-ajax.js.js").unwrap();

    // Microsoft Ajax
    builder
        .add("!**/[Mm]icrosoft{[Aa]jax,[Vv]alidation}*.js")
        .unwrap();

    // NuGet
    builder.add("!**/[Pp]ackages/*.*/**").unwrap();

    // ExtJS
    builder
        .add("!**/extjs/*.{js,xml,txt,html,properties}")
        .unwrap();
    builder
        .add("!**/extjs/{.sencha,docs,builds,cmd,examples,locale,packages,plugins,resources,src,welcome}/**")
        .unwrap();

    // Html5shiv
    builder.add("!**/html5shiv.js").unwrap();

    // Test fixtures
    builder.add("!**/[Tt]es{t,ts}/fixtures/**").unwrap();
    builder.add("!**/[Ss]pe{c,cs}/fixtures/**").unwrap();

    // PhoneGap/Cordova
    builder.add("!**/cordova*.js").unwrap();

    // Foundation js
    builder.add("!**/foundation*.js").unwrap();

    // Vagrant
    builder.add("!**/Vagrantfile").unwrap();

    // .DS_Stores
    builder.add("!**/.[Dd][Ss]_[Ss]tore").unwrap();

    // R packages
    builder.add("!**/vignettes/**").unwrap();
    builder.add("!**/inst/extdata/**").unwrap();

    // Octicons
    builder.add("!**/octicons.css").unwrap();
    builder.add("!**/sprockets-octicons.scss").unwrap();

    // Typesafe Activator
    builder.add("!**/activiator").unwrap();
    builder.add("!**/activator.bat").unwrap();

    // ProGuard
    builder.add("!**/proguard.pro").unwrap();
    builder.add("!**/proguard-rules.pro").unwrap();

    // PuPHPet
    builder.add("!**/puphet/**").unwrap();

    // Android Google APIs
    builder.add("!**/.google_apis/**").unwrap();

    // Jenkins Pipeline
    builder.add("!**/Jenkinsfile").unwrap();

    builder
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_override_single_dir() {
        let vo = add_vendor_override(OverrideBuilder::new("./"))
            .build()
            .unwrap();
        assert!(vo.matched("cache/", true).is_ignore());
        assert!(vo.matched("cache/file.ext", false).is_ignore());
        assert!(vo.matched("first-dir/cache/file.ext", false).is_ignore());
        assert!(vo.matched("not-ignored/peep.ext", false).is_none());
    }

    #[test]
    fn test_override_character_set() {
        let vo = add_vendor_override(OverrideBuilder::new("./"))
            .build()
            .unwrap();
        assert!(vo.matched("Dependencies/module", true).is_ignore());
        assert!(vo.matched("Dependencies/mod/file.ext", false).is_ignore());
        assert!(vo.matched("dependencies/mod/file.ext", false).is_ignore());
        assert!(vo.matched("folder/not-dependencies/module", true).is_none());
    }

    #[test]
    fn test_override_matches_file() {
        let vo = add_vendor_override(OverrideBuilder::new("./"))
            .build()
            .unwrap();
        assert!(vo.matched("some/configure", true).is_ignore());
        assert!(vo.matched("configure", true).is_ignore());
        assert!(vo.matched("dir/dirs/config.guess", false).is_ignore());
        assert!(vo.matched("dir/dirs/config.sub", false).is_ignore());
        assert!(vo.matched("dir/dirs/configure/dirdir", true).is_none());
    }

    #[test]
    fn test_override_multiple_dirs() {
        let vo = add_vendor_override(OverrideBuilder::new("./"))
            .build()
            .unwrap();
        assert!(vo.matched("dir/.yarn/releases/file.ext", false).is_ignore());
    }

    #[test]
    fn test_override_pattern_list() {
        let vo = add_vendor_override(OverrideBuilder::new("./"))
            .build()
            .unwrap();
        assert!(vo.matched("dir/some-min.js", false).is_ignore());
        assert!(vo.matched("dir/some.min.js", false).is_ignore());
        assert!(vo.matched("dir/some.min.css", false).is_ignore());
    }

    #[test]
    fn test_override_character_set_in_pattern_list() {
        let vo = add_vendor_override(OverrideBuilder::new("./"))
            .build()
            .unwrap();
        assert!(vo.matched("dir/microsoftAjax.js", false).is_ignore());
        assert!(vo.matched("dir/microsoftajax.js", false).is_ignore());
    }
}
