use std::fs::File;
use std::io::prelude::*;
use std::path::Path;
use std::net::SocketAddr;
//use std::sync::RwLock;
//use std::collections::HashMap;

//use rand::{thread_rng, Rng};

use lazy_static::*;
use handlebars::Handlebars;
use serde_derive::Deserialize;
use serde_json::value::{Map, Value as Json};

mod filters;
mod handlers;

#[derive(Debug, Deserialize)]
struct Config {
    ip_address: Option<String>,
    resource_folder: Option<String>,
    cert_path: Option<String>,
    key_path: Option<String>,
}

// initialize app settings
lazy_static!{
    static ref TEMPLATES: Handlebars<'static> = load_templates();
    static ref CONFIG: Config = load_config();
}

fn load_templates() -> Handlebars<'static> {
    let mut hb = Handlebars::new();
    let folder = CONFIG.resource_folder.as_ref().unwrap().to_owned();
    let mut file_path = folder.clone() + "/first_page.hbs";
    hb.register_template_file("first_page", &file_path).unwrap();
    file_path = folder.clone() + "/second_page.hbs";
    hb.register_template_file("second_page", &file_path).unwrap();
    hb
}

pub fn render(template_name: &str, data: &Map<String, Json>) -> String {
    TEMPLATES.render(template_name, data)
    .unwrap_or_else(|err| err.to_string())
}

fn load_config() -> Config {
    let path = Path::new("Settings.toml");
    let display = path.display();
    let mut file = match File::open(&path) {
        Err(why) => panic!("Couldn't open {}: {}", display, why),
        Ok(file) => file,
    };
    let mut content = String::new();
    match file.read_to_string(&mut content) {
        Err(why) => panic!("Couldn't read {}: {}", display, why),
        Ok(_) => (),
    }
    let decoded: Config = toml::from_str(&content).unwrap();
    decoded
}

#[tokio::main]
async fn main() {
    let routes = filters::demo_pages();
    let ip_addr = CONFIG.ip_address.as_ref().unwrap();
    let cert_path = CONFIG.cert_path.as_ref().unwrap();
    let key_path = CONFIG.key_path.as_ref().unwrap();
    let socket_addr: SocketAddr = ip_addr.as_str().parse().unwrap(); 
    println!("https demo runs at: {:?}", CONFIG.ip_address);
    warp::serve(routes)
        .tls()
        .cert_path(cert_path)
        .key_path(key_path)
        .run(socket_addr)
        .await;
}
