use std::fs::File;
use std::path::Path;
use std::io::Read;
use std::convert::Infallible;
//use std::collections::HashMap;
//use warp::http::Uri;
use serde_json::value::Map;
//use serde_derive::{Serialize, Deserialize};
//use handlebars::to_json;


pub fn first_page() -> String {
    println!("first page().............");
    let data = Map::new();
    let page = super::TEMPLATES.render("first_page", &data)
    .unwrap_or_else(|err| err.to_string());
    page
}

pub async fn show_home() -> Result<impl warp::Reply, Infallible> {
    Ok( warp::reply::html( first_page() ) )
}

pub async fn second_page() -> Result<impl warp::Reply, Infallible> {
    println!("second page().............");
    let data = Map::new();
    let page = super::TEMPLATES.render("second_page", &data)
    .unwrap_or_else(|err| err.to_string());
    Ok( warp::reply::html(page) )
}

pub async fn get_static_file(file_name: String) -> Result<impl warp::Reply, Infallible> {
    println!("get_static_file({}).............", &file_name);
    let parts: Vec<&str> = file_name.split('.').collect();
    let file_type: &str = match parts[1] {
        "js" => "text/javascript",
        "css" => "text/css",
        "jpg" => "image/jpeg",
        "svg" => "image/svg+xml",
        "png" => "image/png",
        "ico" => "image/x-icon",
        _ => "text/text",
    };
    let folder = super::CONFIG.resource_folder.as_ref().unwrap().to_owned();
    let file_path = folder + "/" + &file_name;
    let path = Path::new(&file_path);
    if !path.exists() {
        panic!("{:?} NOT FOUND!", &path);
    }
    let display = path.display();
    let mut file = match File::open(&path) {
        Err(why) => panic!("Couldn't open {}: {}", display, why),
        Ok(file) => file,
    };
    let mut content = Vec::new();
    match file.read_to_end(&mut content) {
        Err(why) => panic!("Couldn't read {}: {}", display, why),
        Ok(_) => (),
    }
    let response = warp::http::Response::builder()
        .header("content-type", file_type)
        .body(content);
    Ok(response)
}

