use warp::Filter;

use crate::handlers;

/// DEMO Filters
pub fn demo_pages() -> impl Filter<Extract = impl warp::Reply, Error = warp::Rejection> + Clone {
    first_page()
    .or( show_home() )
    .or( second_page() )
    .or( get_static_file() )
} 

/// GET / -> first page (or index page, home page)
pub fn first_page() -> impl Filter<Extract = impl warp::Reply, Error = warp::Rejection> + Clone {
    warp::path::end().map( || warp::reply::html( handlers::first_page() ) )
}

/// GET /home
pub fn show_home() -> impl Filter<Extract = impl warp::Reply, Error = warp::Rejection> + Clone {
    warp::path!("home")
    .and(warp::get())
    .and_then(handlers::show_home)
}

/// GET /second_page
pub fn second_page() -> impl Filter<Extract = impl warp::Reply, Error = warp::Rejection> + Clone {
    warp::path!("second_page")
    .and(warp::get())
    .and_then(handlers::second_page)
}

/// GET /static/<filename with extension such as js, jpg, css, svg>
pub fn get_static_file() -> impl Filter<Extract = impl warp::Reply, Error = warp::Rejection> + Clone {
    warp::path!("static" / String)
    .and( warp::get() )
    .and_then( handlers::get_static_file )
}