use std::fs;
use std::io::{BufReader,BufRead};

#[derive(Debug,PartialEq)]
pub struct Group {
    name: Option<String>,
    gid: Option<u32>,
    user_list: Option<Vec<String>>,
}

fn parse_line(line: String) -> Option<Group> {
    let mut split: Vec<&str> =  line.split(':').collect();
    if split.is_empty() { return None; };
    // Remove 'x' (password)
    split.remove(1);
    let mut users = Vec::new();
    if !split[2].is_empty() {
        let mut owned_users: Vec<&str> = split[2].split(',').collect();
        for user in owned_users {
            users.push(user.to_string());
        }
    }
    let group = Group {
        name: Some(String::from(split[0])),
        gid: Some(split[1].parse::<u32>().unwrap()),
        user_list:
            if !users.is_empty() { Some(users) }
            else { None }
    };
    Some(group)
}

fn read_group() -> Vec<Group> {
    let mut groups = Vec::new();
    let file = match fs::File::open("/etc/group") {
        Ok(s) => { s },
        Err(e) => { panic!(e.to_string()) }
    };
    let file_buffer = BufReader::new(&file);
    for line in file_buffer.lines() {
        match line {
            Ok(l) => {
                groups.push(parse_line(l).unwrap());
            },
            Err(e) => { panic!(e.to_string()) }
        }

    }
    groups
}

#[test]
fn test_parse_line() {
    let group = match parse_line("hell:x:666:trump".to_string()) {
        Some(s) => {
            println!("{:?}", s);
        },
        None => { }
    };
}

#[test]
fn test_read_group() {
    let groups = read_group();
    for group in groups {
        println!("{:?}", group);
    }
}
