extern crate gitlab_api as gitlab;

use std::env;
#[macro_use]
extern crate log;
extern crate env_logger;
extern crate clap;


use gitlab::GitLab;

use gitlab::errors::*;


fn main() {
    if let Err(ref e) = run() {
        println!("error: {}", e);

        for e in e.iter().skip(1) {
            println!("caused by: {}", e);
        }

        // The backtrace is not always generated. Try to run this example
        // with `RUST_BACKTRACE=1`.
        if let Some(backtrace) = e.backtrace() {
            println!("backtrace: {:?}", backtrace);
        }

        ::std::process::exit(1);
    }
}

fn run() -> Result<()> {
    env_logger::init().unwrap();
    info!("starting up");

    let hostname = match env::var("GITLAB_HOSTNAME") {
        Ok(val) => val,
        Err(_) => {
            let default = String::from("gitlab.com");
            println!("Please set environment variable 'GITLAB_HOSTNAME'. Using default '{}'.",
                     default);
            default
        }
    };

    let token = match env::var("GITLAB_TOKEN") {
        Ok(val) => val,
        Err(_) => {
            panic!("Please set environment variable 'GITLAB_TOKEN'. Take it from \
                    http://{}/profile/account",
                   hostname);
        }
    };

    let gl = GitLab::new(&hostname, &token).chain_err(|| "failure to create GitLab instance")?;
    // let gl = GitLab::new(&hostname, &token)
    //     .chain_err(|| "failure to create GitLab instance")?
    //     .scheme("http").port(80);
    // let gl = gl.scheme("http").port(80);

    let matches = clap::App::new("get_id_project")
        .version("1.0")
        .author("Nicolas Bigaouette <nbigaouette@gmail.com>")
        .about("Get the id of a GitLab project from namespace/project.")
        .arg(clap::Arg::with_name("namespace")
            .help("The project's namespace (or group)")
            .long("namespace")
            .short("n")
            .takes_value(true)
            .required(true))
        .arg(clap::Arg::with_name("project")
            .help("The project's name")
            .long("project")
            .short("p")
            .takes_value(true)
            .required(true))
        .get_matches();

    let project_namespace = matches.value_of("namespace").unwrap();
    let project_name = matches.value_of("project").unwrap();

    let project = gl.get_project(project_namespace, project_name)
        .chain_err(|| "cannot get project")?;
    // println!("project: {:?}", project);

    println!("Id for {}/{}: {}",
             project_namespace,
             project_name,
             project.id);

    Ok(())
}
