#!/usr/bin/env bash

# Finds Cargo's `OUT_DIR` directory from the most recent build.
#
# This requires one parameter corresponding to the target directory
# to search for the build output.
cargo_out_dir() {
  # This works by finding the most recent stamp file, which is produced by
  # every ripgrep build.
  local target_dir="$1"
  find "$target_dir" -name gitall-stamp -print0 \
    | xargs -0 ls -t \
    | head -n1 \
    | xargs dirname
}
