use clap::{App, Arg, crate_authors, crate_description, crate_version};

pub fn build_cli() -> App<'static, 'static> {
    App::new("gitall")
        .version(crate_version!())
        .author(crate_authors!(", "))
        .about(crate_description!())
        .arg(Arg::with_name("follow_links")
             .short("L")
             .long("follow")
             .help("Follow symbolic links")
             .long_help("When specified, symbolic links will be followed when navigtating the directory tree."))
        .arg(Arg::with_name("dir")
             .short("D")
             .long("directory")
             .help("The directory to start searching under")
             .takes_value(true)
             .value_name("DIR")
             .default_value("."))
        .arg(Arg::with_name("max_depth")
             .short("d")
             .long("max-depth")
             .help("Descend at most LEVELS of directories below DIR")
             .takes_value(true)
             .value_name("LEVELS"))
        .arg(Arg::with_name("cmd")
             .help("A single git command to run in each repo")
             .index(1)
             .required(true)
             .empty_values(false)
             .multiple(true)
             .value_name("COMMAND"))
}
