#[derive(Debug)]
pub enum Error {
    NoMergeCommit { r#for: String },
    Git2Error(git2::Error),
    PicoArgsError(pico_args::Error),
}

impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::NoMergeCommit { r#for } => {
                write!(f, "No merge commit for {} found", r#for)
            }
            Error::Git2Error(e) => {
                write!(f, "{}", e)
            }
            Error::PicoArgsError(e) => write!(f, "{}", e),
        }
    }
}

impl std::error::Error for Error {}

impl From<git2::Error> for Error {
    fn from(e: git2::Error) -> Self {
        Self::Git2Error(e)
    }
}

impl From<pico_args::Error> for Error {
    fn from(e: pico_args::Error) -> Self {
        Self::PicoArgsError(e)
    }
}

pub type Result<T> = std::result::Result<T, Error>;
