use tokio::time::{sleep, Duration};

use futures::Future;

pub fn now() -> f64 {
    use chrono::Utc;
    Utc::now().timestamp_millis() as f64
}

pub fn block_on<F: Future<Output = ()> + 'static + Sync + Send>(f: F) {
    tokio::spawn(async { f.await });
}

pub fn schedule_repeating<F>(cb: F)
where
    F: 'static + FnMut() + Send,
{
    let timer = timer::Timer::new();
    timer.schedule_repeating(chrono::Duration::seconds(1), cb);
}

pub async fn wait_ms(ms: u32) {
    sleep(Duration::from_millis(ms.into())).await;
}
