use flow_impl::{Implementation, RUN_AGAIN, RunAgain};
use flow_impl_derive::FlowImpl;
use serde_json::Value;

#[derive(FlowImpl)]
/// Convert a String to a number
///
/// ## Include using
/// ```toml
/// [[process]]
/// alias = "to_number"
/// source = "lib://flowstdlib/fmt/to_number"
/// ```
///
/// ## Input
/// * The String to convert
///
/// ## Output
/// * The Number equivalent of String input if possible
pub struct ToNumber;

impl Implementation for ToNumber {
    fn run(&self, mut inputs: Vec<Vec<Value>>) -> (Option<Value>, RunAgain) {
        let mut value = None;
        let input = inputs.remove(0).remove(0);

        match input {
            Value::String(string) => {
                if let Ok(number) = string.parse::<i64>() {
                    let number = Value::Number(serde_json::Number::from(number));
                    value = Some(number);
                }
            },
            _ => {}
        };

        (value, RUN_AGAIN)
    }
}