//! 历史记录

use core::mem::MaybeUninit;
use core::ops;
use core::slice;

pub struct History<T: PartialEq, const N: usize> {
    is_full: bool,
    last: usize,
    logs: MaybeUninit<[T; N]>,
}
impl<T: PartialEq, const N: usize> History<T, N> {
    const CAPACITY: usize = N;
    pub const fn new() -> Self {
        History {
            is_full: false,
            last: 0,
            logs: MaybeUninit::uninit(),
        }
    }
    fn as_ptr(&self) -> *const T {
        self.logs.as_ptr() as *const T
    }
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self.logs.as_mut_ptr() as *mut T
    }
    /// 添加记录
    pub fn insert(&mut self, value: T) -> bool {
        if self.contains(&value) {
            return false;
        }
        unsafe { slice::from_raw_parts_mut(self.as_mut_ptr(), Self::CAPACITY)[self.last] = value };
        if self.last == Self::CAPACITY - 1 {
            self.last = 0;
        } else {
            self.last += 1;
        }
        return true;
    }
}
impl<T: PartialEq, const N: usize> ops::Deref for History<T, N> {
    type Target = [T];

    fn deref(&self) -> &[T] {
        if self.is_full {
            unsafe { slice::from_raw_parts(self.as_ptr(), Self::CAPACITY) }
        } else {
            unsafe { slice::from_raw_parts(self.as_ptr(), self.last) }
        }
    }
}
