# 💀 Executor

```toml
[dependencies]
executor = "0.1"
```
## Features
- [x] `#![no_std]` and minimally uses `alloc` (`Box` and `Arc`)
- [x] handle more than one spawn to parallelize work
- [x] simple enough to learn from! (< 100 lines)

## Example

```rust
use executor::Executor;

pub fn main() -> () {
    Executor::spawn(async {
        println!("Hello");
        sleep(1000).await;
        println!("World");
        sleep(1000).await;
        println!("!");
    });
}
```

## async-std

Want to use [async-std](https://async.rs/)?

```
use executor::*;
use std::time::Duration;
use async_std::task;
use core::sync::atomic::{Ordering,AtomicBool};
use std::thread;

static IS_COMPLETE:AtomicBool = AtomicBool::new(false);

async fn run() {
    println!("hello");
    task::sleep(Duration::from_secs(1)).await;
    println!("world!");
    IS_COMPLETE.store(true,Ordering::Release);
}

fn main() -> () {
    thread::spawn(move || {
        Executor::spawn(run());
    });
    while !IS_COMPLETE.load(Ordering::Acquire) {}
}
```

# License

This project is licensed under either of

 * Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or
   http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license ([LICENSE-MIT](LICENSE-MIT) or
   http://opensource.org/licenses/MIT)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in `executor` by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.
