
#[macro_use]
extern crate error_util;

use std::fs::File;
use std::io;

use error_util::{ErrorType1, ErrorType2};


fn main() {
    match func() {
        Err(err) => {
            println!("Result: {:?}", err);
            println!("Result: {}", err);
            println!("Result: {}", std::error::Error::description(&err));
        },
        Ok(val) => println!("Result: {:?}", val),
    }
    println!("{}", &LocalError::from(ErrorType1{}));

    println!("Done");
}

fn func() -> Result<(), LocalError> {
    let _f = File::open("test.txt")?;
    Ok(())
}


impl_error_group! {
enum LocalError {
    IoError(io::Error, "An IO Error"),
    Error1(ErrorType1),
    Error2(ErrorType2),
}}



