use crate::model::duplicate::Duplicates;
use crate::model::indexed_file::IndexedFiles;

use console::Style;

pub fn pretty_print_duplicates(indexed_files: IndexedFiles, duplicates: Duplicates) {
    let red = Style::new().red().bold();

    for duplicate in duplicates {
        let indexed_file = indexed_files.get(&duplicate.file_1).unwrap();

        println!(
            "{}: {} {}: {}-{}",
            red.apply_to("File"),
            duplicate.file_1,
            red.apply_to("Line Range"),
            duplicate.file_1_line_range.start,
            duplicate.file_1_line_range.end
        );
        println!(
            "{}: {} {}: {}-{}",
            red.apply_to("File"),
            duplicate.file_2,
            red.apply_to("Line Range"),
            duplicate.file_2_line_range.start,
            duplicate.file_2_line_range.end,
        );

        for line_number in duplicate.file_1_line_range.start..(duplicate.file_1_line_range.end + 1)
        {
            println!(
                "{} - {:?}",
                line_number,
                indexed_file.line_number_to_line.get(&line_number).unwrap()
            );
        }

        println!();
    }
}

pub fn json_print_duplicates(duplicates: Duplicates) {
    for duplicate in duplicates {
        println!("{}", serde_json::to_string(&duplicate).unwrap());
    }
}
