use std::fs::File;
use std::io::{self, BufRead};
use std::path::Path;

use crate::model::raw_file::*;

pub fn get_files_in_current_directory() -> RawFiles {
    get_files_in_directory("./")
}

fn get_files_in_directory(directory: &str) -> RawFiles {
    let mut files = Vec::new();

    match std::fs::read_dir(directory) {
        Ok(entries) => {
            for entry in entries {
                match entry {
                    Ok(entry) => {
                        let path = entry.path();
                        let name = path.to_str().unwrap();

                        if path.is_file() {
                            files.push(get_raw_file(&name));
                        } else {
                            files.extend(get_files_in_directory(name));
                        }
                    }
                    Err(error) => {
                        error!("{}", error);
                        std::process::exit(1);
                    }
                }
            }
        }
        Err(error) => {
            error!("{}", error);
            std::process::exit(1);
        }
    }

    files
}

fn get_raw_file(filename: &str) -> RawFile {
    match read_lines(filename) {
        Ok(buffered_lines) => {
            let mut lines = vec![];

            for line in buffered_lines {
                if let Ok(line) = line {
                    lines.push(line.to_string());
                }
            }

            RawFile {
                filename: filename.to_string(),
                lines,
            }
        }
        Err(error) => {
            error!("{}", error);
            std::process::exit(1);
        }
    }
}

fn read_lines<P>(filename: P) -> io::Result<io::Lines<io::BufReader<File>>>
where
    P: AsRef<Path>,
{
    let file = File::open(filename)?;
    Ok(io::BufReader::new(file).lines())
}
