#[macro_use]
extern crate log;
extern crate pretty_env_logger;

use structopt::StructOpt;

mod cli;
mod directory_reader;
mod duplicate_detection;
mod hashing;
mod model;
mod reporter;

fn main() {
    pretty_env_logger::init();
    let arguments = cli::Arguments::from_args();
    debug!("The command line arguments provided are {:?}.", arguments);

    let raw_files = crate::directory_reader::get_files_in_current_directory();
    let indexed_files = crate::model::indexed_file::to_indexed_files(raw_files);
    let hashed_files = crate::model::hashed_file::to_hashed_files(&indexed_files);
    let duplicates = crate::duplicate_detection::get_all_duplicates(hashed_files);
    crate::reporter::pretty_print_duplicates(indexed_files, duplicates);
}
