use crate::model::*;

use console::Style;

pub fn pretty_print_duplicates(
    filename_to_line_number_to_line: FilenameToLineNumberToLine,
    duplicates: Duplicates,
) {
    let red = Style::new().red().bold();

    for duplicate in duplicates {
        let line_number_to_line = filename_to_line_number_to_line
            .get(&duplicate.file_1)
            .unwrap();

        println!(
            "{}: {} {}: {}-{}",
            red.apply_to("File"),
            duplicate.file_1,
            red.apply_to("Line Range"),
            duplicate.file_1_line_range.start,
            duplicate.file_1_line_range.end
        );
        println!(
            "{}: {} {}: {}-{}",
            red.apply_to("File"),
            duplicate.file_2,
            red.apply_to("Line Range"),
            duplicate.file_2_line_range.start,
            duplicate.file_2_line_range.end,
        );

        for line_number in duplicate.file_1_line_range.start..(duplicate.file_1_line_range.end + 1)
        {
            println!(
                "{} - {:?}",
                line_number,
                line_number_to_line.get(&line_number).unwrap()
            );
        }

        println!();
    }
}
