#[macro_use]
extern crate log;
extern crate pretty_env_logger;

use structopt::StructOpt;

mod cli;
mod duplicates;
mod files;
mod hashing;
mod model;
mod reporter;

fn main() {
    pretty_env_logger::init();
    let arguments = cli::Arguments::from_args();
    debug!("The command line arguments provided are {:?}.", arguments);

    let raw_files = crate::files::get_files_in_current_directory();
    let (hashed_files, filename_to_line_number_to_line) = crate::model::to_file_content(raw_files);
    let duplicates = crate::duplicates::get_all_duplicates(hashed_files);
    crate::reporter::pretty_print_duplicates(filename_to_line_number_to_line, duplicates);
}
