# Duplicate Code
[![crates.io](https://img.shields.io/crates/v/duplicate_code)](https://crates.io/crates/duplicate_code) [![pipeline status](https://gitlab.com/DeveloperC/duplicate_code/badges/master/pipeline.svg)](https://gitlab.com/DeveloperC/duplicate_code/commits/master) [![License: AGPL v3](https://img.shields.io/badge/License-AGPLv3-blue.svg)](https://www.gnu.org/licenses/agpl-3.0)


A tool for parsing directories scanning all the files within to find duplicate segments of code across files.


## Upcoming
 * Unit Testing
 * End To End Testing
 * Ignore Line Regex
 * JSON Output Option


## Content
 * [Usage](#usage)
   + [Usage - Logging](#usage-logging)
 * [Compiling via Local Repository](#compiling-via-local-repository)
 * [Compiling via Cargo](#compiling-via-cargo)
 * [Issues/Feature Requests](#issuesfeature-requests)


## Usage
Duplicate Code scans the current directory and all sub-directories to find every file, then each file is compared against all the other files to find duplicate segments across the files.


## Usage - Logging
The crates `pretty_env_logger` and `log` are used to provide logging.
The environment variable `RUST_LOG` can be used to set the logging level.
See [https://crates.io/crates/pretty_env_logger](https://crates.io/crates/pretty_env_logger) for more detailed documentation.


## Compiling via Local Repository
Checkout the code repository locally, change into the repository's directory and then build via cargo.
Using the `--release` flag produces an optimised binary but takes longer to compile.

```
git clone git@gitlab.com:DeveloperC/duplicate_code.git
cd duplicate_code/
cargo build --release
```

The compiled binary is present in `target/release/duplicate_code`.


## Compiling via Cargo
Cargo is the Rust package manager, using the `install` sub-command it pulls the crate from `crates.io` and then compiles the binary locally.
`cargo install` places the produced binary at `$HOME/.cargo/bin/duplicate_code`.

```
cargo install duplicate_code
```


## Issues/Feature Requests
To report a bug/issue or request a new feature use [https://gitlab.com/DeveloperC/duplicate_code/-/issues](https://gitlab.com/DeveloperC/duplicate_code/-/issues).
