#[macro_use]
extern crate log;
extern crate pretty_env_logger;

mod duplicates;
mod files;
mod hashing;
mod model;

fn main() {
    pretty_env_logger::init();

    let raw_files = crate::files::get_files_in_current_directory();
    let files = crate::model::to_file_content(raw_files);
    let duplicates = crate::duplicates::get_all_duplicates(files);

    for duplicate in duplicates {
        println!("{:?}", duplicate);
    }
}
