//  cargo run --example stats -- <container>
use docker_api::Docker;
use futures::StreamExt;
use std::env;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    let docker = Docker::new("tcp://127.0.0.1:80")?;
    let containers = docker.containers();
    let id = env::args()
        .nth(1)
        .expect("Usage: cargo run --example stats -- <container>");

    while let Some(result) = containers.get(&id).stats().next().await {
        match result {
            Ok(stat) => println!("{:?}", stat),
            Err(e) => eprintln!("Error: {}", e),
        }
    }

    Ok(())
}
