use docker_api::{Docker, NetworkCreateOptions};
use std::env;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    let docker = Docker::new("tcp://127.0.0.1:80")?;
    let network_name = env::args()
        .nth(1)
        .expect("You need to specify a network name");
    match docker
        .networks()
        .create(
            &NetworkCreateOptions::builder(network_name)
                .driver("bridge")
                .build(),
        )
        .await
    {
        Ok(info) => println!("{:?}", info),
        Err(e) => eprintln!("Error: {}", e),
    }

    Ok(())
}
