use super::MemSize;
use phf::{phf_map, Map};

pub static MEMORY_SIZES: Map<&str, MemSize> = phf_map! {
    "STM32F030C6Tx" => MemSize{flash: 32, ram: 4},
    "STM32F030C8Tx" => MemSize{flash: 64, ram: 8},
    "STM32F030CCTx" => MemSize{flash: 256, ram: 32},
    "STM32F030F4Px" => MemSize{flash: 16, ram: 4},
    "STM32F030K6Tx" => MemSize{flash: 32, ram: 4},
    "STM32F030R8Tx" => MemSize{flash: 64, ram: 8},
    "STM32F030RCTx" => MemSize{flash: 256, ram: 32},
    "STM32F031C4Tx" => MemSize{flash: 16, ram: 4},
    "STM32F031C6Tx" => MemSize{flash: 32, ram: 4},
    "STM32F031E6Yx" => MemSize{flash: 32, ram: 4},
    "STM32F031F4Px" => MemSize{flash: 16, ram: 4},
    "STM32F031F6Px" => MemSize{flash: 32, ram: 4},
    "STM32F031G4Ux" => MemSize{flash: 16, ram: 4},
    "STM32F031G6Ux" => MemSize{flash: 32, ram: 4},
    "STM32F031K4Ux" => MemSize{flash: 16, ram: 4},
    "STM32F031K6Tx" => MemSize{flash: 32, ram: 4},
    "STM32F031K6Ux" => MemSize{flash: 32, ram: 4},
    "STM32F038C6Tx" => MemSize{flash: 32, ram: 4},
    "STM32F038E6Yx" => MemSize{flash: 32, ram: 4},
    "STM32F038F6Px" => MemSize{flash: 32, ram: 4},
    "STM32F038G6Ux" => MemSize{flash: 32, ram: 4},
    "STM32F038K6Ux" => MemSize{flash: 32, ram: 4},
    "STM32F042C4Tx" => MemSize{flash: 16, ram: 6},
    "STM32F042C4Ux" => MemSize{flash: 16, ram: 6},
    "STM32F042C6Tx" => MemSize{flash: 32, ram: 6},
    "STM32F042C6Ux" => MemSize{flash: 32, ram: 6},
    "STM32F042F4Px" => MemSize{flash: 16, ram: 6},
    "STM32F042F6Px" => MemSize{flash: 32, ram: 6},
    "STM32F042G4Ux" => MemSize{flash: 16, ram: 6},
    "STM32F042G6Ux" => MemSize{flash: 32, ram: 6},
    "STM32F042K4Tx" => MemSize{flash: 16, ram: 6},
    "STM32F042K4Ux" => MemSize{flash: 16, ram: 6},
    "STM32F042K6Tx" => MemSize{flash: 32, ram: 6},
    "STM32F042K6Ux" => MemSize{flash: 32, ram: 6},
    "STM32F042T6Yx" => MemSize{flash: 32, ram: 6},
    "STM32F048C6Ux" => MemSize{flash: 32, ram: 6},
    "STM32F048G6Ux" => MemSize{flash: 32, ram: 6},
    "STM32F048T6Yx" => MemSize{flash: 32, ram: 6},
    "STM32F051C4Tx" => MemSize{flash: 16, ram: 8},
    "STM32F051C4Ux" => MemSize{flash: 16, ram: 8},
    "STM32F051C6Tx" => MemSize{flash: 32, ram: 8},
    "STM32F051C6Ux" => MemSize{flash: 32, ram: 8},
    "STM32F051C8Tx" => MemSize{flash: 64, ram: 8},
    "STM32F051C8Ux" => MemSize{flash: 64, ram: 8},
    "STM32F051K4Tx" => MemSize{flash: 16, ram: 8},
    "STM32F051K4Ux" => MemSize{flash: 16, ram: 8},
    "STM32F051K6Tx" => MemSize{flash: 32, ram: 8},
    "STM32F051K6Ux" => MemSize{flash: 32, ram: 8},
    "STM32F051K8Tx" => MemSize{flash: 64, ram: 8},
    "STM32F051K8Ux" => MemSize{flash: 64, ram: 8},
    "STM32F051R4Tx" => MemSize{flash: 16, ram: 8},
    "STM32F051R6Tx" => MemSize{flash: 32, ram: 8},
    "STM32F051R8Hx" => MemSize{flash: 64, ram: 8},
    "STM32F051R8Tx" => MemSize{flash: 64, ram: 8},
    "STM32F051T8Yx" => MemSize{flash: 64, ram: 8},
    "STM32F058C8Ux" => MemSize{flash: 64, ram: 8},
    "STM32F058R8Hx" => MemSize{flash: 64, ram: 8},
    "STM32F058R8Tx" => MemSize{flash: 64, ram: 8},
    "STM32F058T8Yx" => MemSize{flash: 64, ram: 8},
    "STM32F070C6Tx" => MemSize{flash: 32, ram: 6},
    "STM32F070CBTx" => MemSize{flash: 128, ram: 16},
    "STM32F070F6Px" => MemSize{flash: 32, ram: 6},
    "STM32F070RBTx" => MemSize{flash: 128, ram: 16},
    "STM32F071C8Tx" => MemSize{flash: 64, ram: 16},
    "STM32F071C8Ux" => MemSize{flash: 64, ram: 16},
    "STM32F071CBTx" => MemSize{flash: 128, ram: 16},
    "STM32F071CBUx" => MemSize{flash: 128, ram: 16},
    "STM32F071CBYx" => MemSize{flash: 128, ram: 16},
    "STM32F071RBTx" => MemSize{flash: 128, ram: 16},
    "STM32F071V8Hx" => MemSize{flash: 64, ram: 16},
    "STM32F071V8Tx" => MemSize{flash: 64, ram: 16},
    "STM32F071VBHx" => MemSize{flash: 128, ram: 16},
    "STM32F071VBTx" => MemSize{flash: 128, ram: 16},
    "STM32F072C8Tx" => MemSize{flash: 64, ram: 16},
    "STM32F072C8Ux" => MemSize{flash: 64, ram: 16},
    "STM32F072CBTx" => MemSize{flash: 128, ram: 16},
    "STM32F072CBUx" => MemSize{flash: 128, ram: 16},
    "STM32F072CBYx" => MemSize{flash: 128, ram: 16},
    "STM32F072R8Tx" => MemSize{flash: 64, ram: 16},
    "STM32F072RBHx" => MemSize{flash: 128, ram: 16},
    "STM32F072RBIx" => MemSize{flash: 128, ram: 16},
    "STM32F072RBTx" => MemSize{flash: 128, ram: 16},
    "STM32F072V8Hx" => MemSize{flash: 64, ram: 16},
    "STM32F072V8Tx" => MemSize{flash: 64, ram: 16},
    "STM32F072VBHx" => MemSize{flash: 128, ram: 16},
    "STM32F072VBTx" => MemSize{flash: 128, ram: 16},
    "STM32F078CBTx" => MemSize{flash: 128, ram: 16},
    "STM32F078CBUx" => MemSize{flash: 128, ram: 16},
    "STM32F078CBYx" => MemSize{flash: 128, ram: 16},
    "STM32F078RBHx" => MemSize{flash: 128, ram: 16},
    "STM32F078RBTx" => MemSize{flash: 128, ram: 16},
    "STM32F078VBHx" => MemSize{flash: 128, ram: 16},
    "STM32F078VBTx" => MemSize{flash: 128, ram: 16},
    "STM32F091CBTx" => MemSize{flash: 128, ram: 32},
    "STM32F091CBUx" => MemSize{flash: 128, ram: 32},
    "STM32F091CCTx" => MemSize{flash: 256, ram: 32},
    "STM32F091CCUx" => MemSize{flash: 256, ram: 32},
    "STM32F091RBTx" => MemSize{flash: 128, ram: 32},
    "STM32F091RCHx" => MemSize{flash: 256, ram: 32},
    "STM32F091RCTx" => MemSize{flash: 256, ram: 32},
    "STM32F091RCYx" => MemSize{flash: 256, ram: 32},
    "STM32F091VBTx" => MemSize{flash: 128, ram: 32},
    "STM32F091VCHx" => MemSize{flash: 256, ram: 32},
    "STM32F091VCTx" => MemSize{flash: 256, ram: 32},
    "STM32F098CCTx" => MemSize{flash: 256, ram: 32},
    "STM32F098CCUx" => MemSize{flash: 256, ram: 32},
    "STM32F098RCHx" => MemSize{flash: 256, ram: 32},
    "STM32F098RCTx" => MemSize{flash: 256, ram: 32},
    "STM32F098RCYx" => MemSize{flash: 256, ram: 32},
    "STM32F098VCHx" => MemSize{flash: 256, ram: 32},
    "STM32F098VCTx" => MemSize{flash: 256, ram: 32},
};
