csv-exec runs a command for each line of a CSV file. The command's arguments are replaced by the value of the CSV columns. The output is written in a new column.

```sh
$ cat test.csv
Id,Dir
24,example.com/a
68,example.com/b

$ csv-exec 'echo $2/$1' <test.csv
Id,Dir,Result
24,example.com/a,example.com/a/24
68,example.com/b,example.com/b/68
```

The regex that parses the arguments can be changed:

```sh
$ csv-exec 'echo €2/€1' --arg-regex '€([0-9]+)' <test.csv
Id,Dir,Result
24,example.com/a,example.com/a/24
68,example.com/b,example.com/b/68
```

The help, generated by [clap](https://crates.io/crates/clap):

```sh
$ csv-exec -h
csv-exec 0.3.0
niladic <git@nil.choron.cc>
Execute a command on each record of a CSV.

USAGE:
    csv-exec [FLAGS] [OPTIONS] <COMMAND>

FLAGS:
    -h, --help          Prints help information
    -n, --no-headers    Do not read the first line as a header line
    -V, --version       Prints version information

OPTIONS:
        --arg-regex <REGEX>           Regex used to parse the column position in the command args.
                                      Position begins at 1.
                                      Only the first capturing group is used.
                                      Syntax: https://docs.rs/regex/1.3.4/regex/index.html#syntax
                                       [default: \$([0-9]+)]
    -d, --delimiter <CHAR>            CSV delimiter (\t for tabs) [default: ,]
    -i, --input <FILE>                Input CSV file [stdin by default]
        --new-column-name <STRING>    Name of the new column which contains the results [default: Result]
        --out-delimiter <CHAR>        Output CSV delimiter, if different from delimiter (\t for tabs)
    -o, --output <FILE>               Output CSV [stdout by default]
        --quote <CHAR>                CSV quote [default: "]

ARGS:
    <COMMAND>    The command to execute
```
