# CSS Modules

[![Build Status](https://travis-ci.org/anarchistmae/css-modules-rs.svg?branch=master)](https://travis-ci.org/anarchistmae/css-modules-rs)
[![Latest Version](https://img.shields.io/crates/v/css-modules.svg)](https://crates.io/crates/css-modules)
[![Documentation](https://docs.rs/css-modules/badge.svg)](https://docs.rs/css-modules)
[![Minimum rustc version](https://img.shields.io/badge/rustc-nightly-yellow.svg)](https://gitlab.com/anarchistmae/css-modules-rs#versions)
[![License:MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
![lines of code](https://tokei.rs/b1/gitlab/anarchistmae/css-modules-rs)

The [CSS Modules] project defines CSS Modules as:

> A **CSS Module** is a CSS file in which all class names and animation names are scoped locally by default.

This implementation is however currently immature and has not (as far as I'm aware) been used in a real world situation. Currently only animation and class names are locally scoped and the following work is in progress:

- Inlining `url()` and `@import` statements
- Creating or integrating with a asset compilation tool tool (Rollup, Webpack, etc)

## Usage

Add this crate as a build dependency and as a regular dependency:

```toml
[dependencies]
css-modules = "0.5"

[build-dependencies]
css-modules = "0.5"
```

Create a build script (`build.rs`) in the root of your project:

```rust
use css_modules::CssModules;

fn main() {
    let mut css_modules = CssModules::default();

    // Include all CSS files in the src dir:
    css_modules.add_modules("src/**/*.css").unwrap();

    // Compile all modules and export CSS into one file:
    css_modules.compile("public/app.css");
}
```

And then finally, you can include CSS modules:

```rust
use css_modules::include_css_module;

let css = include_css_module!("test.css"); // relative path to your CSS
let myClass = css["original-class-name"]; // aliased class name
```

For more detailed examples, look in the `examples/` directory.

[CSS Modules]: https://github.com/css-modules/css-modules