extern crate css_modules;

use css_modules::*;

#[test]
fn include_css_module() {
    include_css_module!("simple.css");
}

#[test]
fn include_css_module_with_name() {
    let css = include_css_module!("simple", "simple.css");

    assert_eq!("simple", css.name);
}

#[test]
fn css_module_contains_class() {
    let css = include_css_module!("simple.css");

    assert!(css.id("testOne").is_ok());
}

#[test]
fn css_module_does_not_contain_class() {
    let css = include_css_module!("simple.css");

    assert!(css.id("testFour").is_err());
}

#[test]
fn css_module_get_class() {
    let css = include_css_module!("simple.css");
    let stylesheet = format!("{}", css);
    let starts_with = ".macros_css_module_get_class_";

    assert_ne!("testOne", css.id("testOne").unwrap());
    assert_eq!(stylesheet[0..starts_with.len()], starts_with[..]);
}

#[test]
fn css_module_get_missing_class() {
    let css = include_css_module!("simple.css");

    assert_eq!("testFour", css.id("testFour").unwrap_err());
}
