# CSS Modules

[![Build Status](https://travis-ci.org/anarchistmae/css-modules-rs.svg?branch=master)](https://travis-ci.org/anarchistmae/css-modules-rs)
[![Latest Version](https://img.shields.io/crates/v/css-modules.svg)](https://crates.io/crates/css-modules)
[![Documentation](https://docs.rs/css-modules/badge.svg)](https://docs.rs/css-modules)
[![Minimum rustc version](https://img.shields.io/badge/rustc-1.31+-yellow.svg)](https://gitlab.com/anarchistmae/css-modules-rs#versions)
[![License:MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
![lines of code](https://tokei.rs/b1/gitlab/anarchistmae/css-modules-rs)

The [CSS Modules] project defines CSS Modules as:

> A **CSS Module** is a CSS file in which all class names and animation names are scoped locally by default.

This implementation is however currently immature and has not (as far as I'm aware) been used in a real world situation. Currently only animation and class names are locally scoped and the following work is in progress:

- Inlining `url()` and `@import` statements

## Usage

A `Module` can be constructed manually:

```rust
use css_modules::stylesheet::*;

let css = Stylesheet::new("my_module", ".myStyles {}").unwrap();
```

Or if you would prefer to use automatic module naming based on source code, through a macro:

```rust
use css_modules::*;

let css = css_module!(".myStyles {}");
```

The same as above, but from a file relative to the current source file:

```rust
use css_modules::*;

let css = include_css_module!("test.css");
```

Which is the equivelent of doing:

```rust
use css_modules::*;

let css = css_module!(include_str!("test.css"));
```

For more detailed examples, look in the `examples/` directory.

[CSS Modules]: https://github.com/css-modules/css-modules