extern crate css_modules;

use css_modules::*;

#[test]
fn write_module_to_stylesheet() {
    let mut stylesheet = Stylesheet::new();
    let module = css_module!(".test {}");
    let starts_with = ".stylesheet_write_module_to_stylesheet_";
    let ends_with = "test_0 {}";

    stylesheet.write(&module).unwrap();

    let stylesheet = stylesheet.to_string();

    assert_eq!(stylesheet[0..starts_with.len()], starts_with[..]);
    assert_eq!(
        stylesheet[stylesheet.len() - ends_with.len()..],
        ends_with[..]
    );
}
