extern crate css_modules;

use css_modules::*;

#[test]
fn include_css_module() {
    include_css_module!("simple.css");
}

#[test]
fn include_css_module_with_name() {
    let css = include_css_module!("simple", "simple.css");

    assert_eq!("simple", css.name);
}

#[test]
fn css_module_contains_class() {
    let css = include_css_module!("simple.css");

    assert!(css.contains("testOne"));
}

#[test]
fn css_module_does_not_contain_class() {
    let css = include_css_module!("simple.css");

    assert_eq!(false, css.contains("testFour"));
}

#[test]
fn css_module_get_class() {
    let css = include_css_module!("simple.css");

    assert_ne!("testOne", css.get("testOne"));
}

#[test]
fn css_module_get_missing_class() {
    let css = include_css_module!("simple.css");

    assert_eq!("testFour", css.get("testFour"));
}
