//! Contains a custom type definition for a 32-bit-wide byte array. 
//! 
//! To do: maybe integrate with other crates e.g. ethcore-bytes, or further tune
//! it e.g. with a wrapper for input and output.

use std::cmp::Ordering;

#[derive(Eq, PartialEq)]
/// Creates a custom Bytes32 type, a 4 byte wide vector.
pub struct Bytes32<'a> {
   pub store: Vec<[&'a u8; 4]>, 
}


impl<'a> Ord for Bytes32<'a> {
    fn cmp(&self, other: &Bytes32) -> Ordering {

        for _i in 0..3 {
            if other.store[_i] > self.store[_i] {
                return Ordering::Greater;
            }
            if other.store[_i] < self.store[_i] {
                return Ordering::Less;
            }
        }
        Ordering::Equal
    }
}

impl<'a> PartialOrd for Bytes32<'a> {
    fn partial_cmp(&self, other: &Bytes32) -> Option<Ordering> {
        Some(self.cmp(other))
    }
}
