# Development Notes

## Features

By default, this crate assumes `std` is present, and links against it.

`#![no_std]` can be turned on by disabling default features and enabling the
`alloc` feature, with either the `--features=alloc` Cargo flag or the

```toml
[dependencies.bitvec]
version = "*"
default-features = false
features = ["alloc"]
```

configuration.

The `alloc` feature links agains the `alloc` crate, and changes the symbol
imports needed to retain full functionality even without `std`.

Disabling the `alloc` feature removes the `BitVec` type, the `bitvec!` macro,
and all dynamic memory usage. The `BitSlice` type only loses its formatting
traits.

The configuration attributes in the source code are arrayed in order of
increasing functionality. That is, `#[cfg(not(feature = "alloc"))]` is first,
since it is only true when both `alloc` and `std` features are disabled, then
`#[cfg(all(feature = "alloc", not(feature = "std")))]` is second, since it is
true when `alloc` is enabled but `std` is not, and `#[cfg(feature = "std")]` is
last, since it is true when both `alloc` and `std` are present.

The `std` feature depends on `alloc`, so it is impossible to have `std` enabled
but `alloc` disabled.
