#![cfg(test)]
#![feature(test)]

extern crate test;

use bitvec::prelude::*;

use test::Bencher;

#[bench]
fn vec_shift_left_right_even(b: &mut Bencher) {
	let mut bv = BitVec::<BigEndian, u8>::from_slice(&[0xA5; 32]);

	b.iter(|| {
		bv <<= 8;
		bv >>= 8;
	});
}

#[bench]
fn vec_shift_left_right_misalign(b: &mut Bencher) {
	let mut bv = BitVec::<BigEndian, u8>::from_slice(&[0xA5; 32]);

	b.iter(|| {
		bv <<= 12;
		bv >>= 12;
	});
}

/* Results:

Original Shl and Shr implementation:

3064 +- 421
3197 +- 364
*/
