#[macro_use]
extern crate bip_bencode;

use bip_bencode::{BencodeRef, BDecodeOpt, BRefAccess};

fn main() {
    let bencode = ben_map! {
        "asd" => ben_int!(-560),
        "asd2" => ben_map! {
            "tt" => ben_list!(ben_bytes!("ASD"))
        }
    };
    let bytes = bencode.encode();

    let decoded = BencodeRef::decode(&bytes, BDecodeOpt::new(5, true)).unwrap();
    let int_obj = decoded.dict().unwrap().lookup(&b"asd"[..]).unwrap();

    let text = String::from_utf8(int_obj.buffer().to_vec()).unwrap();

    println!("{:?}", text);
}