# [aws_lambda_events](https://github.com/srijs/rust-aws-lambda/tree/master/aws_lambda_events)

This crate provides strongly-typed AWS Lambda event types for use with [AWS Lambda event sources](https://docs.aws.amazon.com/lambda/latest/dg/invoking-lambda-function.html).

## Usage

The crate itself has no AWS Lambda handler logic and instead exists to serialize
and deserialize AWS Lambda events into strongly-typed Rust structs.

The types
defined in this crate are usually used with handlers / runtimes provided by
projects such as [`rust-aws-lambda`](https://github.com/srijs/rust-aws-lambda),
[`rust-crowbar`](https://github.com/ilianaw/rust-crowbar), and [`serverless_rust`](https://github.com/softprops/serverless-rust).

Before listing this crate as a direct dependency, check to make sure your Lambda handler / runtime crate doesn't already include and export it. For example, [`rust-aws-lambda`](https://github.com/srijs/rust-aws-lambda) includes this as a subcrate and the types can be accessed from `aws_lambda::event`. There is no need to use this crate directly if you are using such a runtime, though there is nothing preventing you from doing so.

## How it works

This crate is automatically generated by [`aws_lambda_events_codegen`](https://github.com/srijs/rust-aws-lambda/tree/master/aws_lambda_events_codegen). It parses event definitions from the [official Go SDK](https://github.com/aws/aws-lambda-go/tree/master/events) and thus is generally up-to-date. Additionally, tests with example events are generated to check correctness and any documentation comments are preserved and used in rustdoc.

## Dealing with `null` and empty strings in AWS Lambda input

The [official Lambda Go SDK](https://github.com/aws/aws-lambda-go/tree/master/events) sometimes marks a field as required when the underlying Lambda event json could actually be `null` or an empty string. Normally, this would cause a panic as Rust is much more strict.

This crate deals with this reality by marking all required json string fields as `Option<String>` in Rust. Json `null` or the empty string are deserialized into Rust structs as `None`.

## Contributing

This project is currently on GitHub as part of [`rust-aws-lambda`](https://github.com/srijs/rust-aws-lambda/tree/master/aws_lambda_events). While it is not at all coupled to `rust-aws-lambda`, for development and testing purposes it made sense to include it in that workspace. This decision may be revisited in the future if it causes major pain for contributors. Please let us know if that is the case.

All files in the `generated` directory should not be manually edited and are generated by [`aws_lambda_events_codegen`](https://github.com/srijs/rust-aws-lambda/tree/master/aws_lambda_events_codegen). Any changes for files in `generated` must happen in [`aws_lambda_events_codegen`](https://github.com/srijs/rust-aws-lambda/tree/master/aws_lambda_events_codegen).

We have no desire to manually write event definitions and contributions to that effect will not be accepted. If the [official Go SDK](https://github.com/aws/aws-lambda-go/tree/master/events) is missing an event definition, please file a bug on that project rather than submitting a fix here. Once the official Go SDK has included your changes this project will pick up the new event definitions.
