use crate::future::Future;
use crate::stream::Stream;

/// Trait to represent types that can be created by summing up a stream.
///
/// This trait is used to implement the [`sum`] method on streams. Types which
/// implement the trait can be generated by the [`sum`] method. Like
/// [`FromStream`] this trait should rarely be called directly and instead
/// interacted with through [`Stream::sum`].
///
/// [`sum`]: trait.Sum.html#tymethod.sum
/// [`FromStream`]: trait.FromStream.html
/// [`Stream::sum`]: trait.Stream.html#method.sum
#[cfg_attr(feature = "docs", doc(cfg(unstable)))]
#[cfg(any(feature = "unstable", feature = "docs"))]
pub trait Sum<A = Self>: Sized {
    /// Method which takes a stream and generates `Self` from the elements by
    /// "summing up" the items.
    fn sum<S, F>(stream: S) -> F
    where
        S: Stream<Item = A>,
        F: Future<Output = Self>;
}
