use crate::future::Future;
use crate::stream::Stream;

/// Trait to represent types that can be created by productming up a stream.
///
/// This trait is used to implement the [`product`] method on streams. Types which
/// implement the trait can be generated by the [`product`] method. Like
/// [`FromStream`] this trait should rarely be called directly and instead
/// interacted with through [`Stream::product`].
///
/// [`product`]: trait.Product.html#tymethod.product
/// [`FromStream`]: trait.FromStream.html
/// [`Stream::product`]: trait.Stream.html#method.product
#[cfg_attr(feature = "docs", doc(cfg(unstable)))]
#[cfg(any(feature = "unstable", feature = "docs"))]
pub trait Product<A = Self>: Sized {
    /// Method which takes a stream and generates `Self` from the elements by
    /// multiplying the items.
    fn product<S, F>(stream: S) -> F
    where
        S: Stream<Item = A>,
        F: Future<Output = Self>;
}
