# GCode Parser

This crate aims at providing a gcode parser to the rusty printer project (and other if it can fit).

The minimal footprint is achieved with all features disabled and is in the order of **~80B** of
RAM and around **2kB** of Flash memory. The typical set of features
`["parse-trailing-comment", "parse-checksum", "optional-value"]` has a footprint of around **4kB**
of flash memory for around **80B** of RAM.
Finally with all features, the memory footprint reaches around **7kB** in flash and around **170B**
in RAM.

## Features

- `std` : Enabled by default
- `parse-comments` : enables the parser to return `GCode::Comment(String)`; requires an allocator.
- `parse-trailing-comment`: allows line to end with a `; comment`.
- `parse-checksum` : Enables the use of xorsum.
- `parse-parameters` : Enables the use of `#` parameters ; requires an allocator.
  If `string-value` is enabled then parameters may use string index.
  If `optional-value` is enabled then parameters value may be omitted but **NOT** the indices.
- `parse-expressions` : Enables parsing infix expressions ; requires an allocator.
- `optional-value` : Allows to omit in `RealValue` in word and parameter value positions.
  Parameter indices cannot be omitted nor can be literals in expressions.
- `string-value` : Allows `RealValue` to be a string. Any character preceded with `\` will be
  used as is (useful for `"`).

## Design
### Constraints
- No recursion.
- Reduced RAM footprint
- Reduced ROM footprint

