# Copyright (c) 2012-2013, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.

from . import AWSObject, AWSProperty, Tags
from .validators import (boolean, cloudfront_restriction_type,
                         cloudfront_event_type,
                         cloudfront_forward_type,
                         cloudfront_viewer_protocol_policy, integer,
                         positive_integer, priceclass_type, network_port)


class Cookies(AWSProperty):
    props = {
        'Forward': (cloudfront_forward_type, True),
        'WhitelistedNames': ([str], False),
    }


class ForwardedValues(AWSProperty):
    props = {
        'Cookies': (Cookies, False),
        'Headers': ([str], False),
        'QueryString': (boolean, True),
        'QueryStringCacheKeys': ([str], False),
    }


class LambdaFunctionAssociation(AWSProperty):
    props = {
        'EventType': (cloudfront_event_type, False),
        'LambdaFunctionARN': (str, False),
    }


class CacheBehavior(AWSProperty):
    props = {
        'AllowedMethods': ([str], False),
        'CachedMethods': ([str], False),
        'Compress': (boolean, False),
        'DefaultTTL': (integer, False),
        'FieldLevelEncryptionId': (str, False),
        'ForwardedValues': (ForwardedValues, True),
        'LambdaFunctionAssociations': ([LambdaFunctionAssociation], False),
        'MaxTTL': (integer, False),
        'MinTTL': (integer, False),
        'PathPattern': (str, True),
        'SmoothStreaming': (boolean, False),
        'TargetOriginId': (str, True),
        'TrustedSigners': ([str], False),
        'ViewerProtocolPolicy': (cloudfront_viewer_protocol_policy, True),
    }


class DefaultCacheBehavior(AWSProperty):
    props = {
        'AllowedMethods': ([str], False),
        'CachedMethods': ([str], False),
        'Compress': (boolean, False),
        'DefaultTTL': (integer, False),
        'FieldLevelEncryptionId': (str, False),
        'ForwardedValues': (ForwardedValues, True),
        'LambdaFunctionAssociations': ([LambdaFunctionAssociation], False),
        'MaxTTL': (integer, False),
        'MinTTL': (integer, False),
        'SmoothStreaming': (boolean, False),
        'TargetOriginId': (str, True),
        'TrustedSigners': (list, False),
        'ViewerProtocolPolicy': (cloudfront_viewer_protocol_policy, True),
    }


class S3Origin(AWSProperty):
    props = {
        'DomainName': (str, True),
        'OriginAccessIdentity': (str, False),
    }


class CustomOriginConfig(AWSProperty):
    props = {
        'HTTPPort': (network_port, False),
        'HTTPSPort': (network_port, False),
        'OriginKeepaliveTimeout': (integer, False),
        'OriginProtocolPolicy': (str, True),
        'OriginReadTimeout': (integer, False),
        'OriginSSLProtocols': ([str], False),
    }


class OriginCustomHeader(AWSProperty):
    props = {
        'HeaderName': (str, True),
        'HeaderValue': (str, True),
    }


class S3OriginConfig(AWSProperty):
    props = {
        'OriginAccessIdentity': (str, False),
    }


class Origin(AWSProperty):
    props = {
        'CustomOriginConfig': (CustomOriginConfig, False),
        'DomainName': (str, True),
        'Id': (str, True),
        'OriginCustomHeaders': ([OriginCustomHeader], False),
        'OriginPath': (str, False),
        'S3OriginConfig': (S3OriginConfig, False),

    }


class Logging(AWSProperty):
    props = {
        'Bucket': (str, True),
        'IncludeCookies': (boolean, False),
        'Prefix': (str, False),
    }


class CustomErrorResponse(AWSProperty):
    props = {
        'ErrorCachingMinTTL': (positive_integer, False),
        'ErrorCode': (positive_integer, True),
        'ResponseCode': (positive_integer, False),
        'ResponsePagePath': (str, False),
    }


class GeoRestriction(AWSProperty):
    props = {
        'Locations': ([str], False),
        'RestrictionType': (cloudfront_restriction_type, True),
    }


class Restrictions(AWSProperty):
    props = {
        'GeoRestriction': (GeoRestriction, True),
    }


class ViewerCertificate(AWSProperty):
    props = {
        'AcmCertificateArn': (str, False),
        'CloudFrontDefaultCertificate': (boolean, False),
        'IamCertificateId': (str, False),
        'MinimumProtocolVersion': (str, False),
        'SslSupportMethod': (str, False),
    }


class DistributionConfig(AWSProperty):
    props = {
        'Aliases': (list, False),
        'CacheBehaviors': ([CacheBehavior], False),
        'Comment': (str, False),
        'CustomErrorResponses': ([CustomErrorResponse], False),
        'DefaultCacheBehavior': (DefaultCacheBehavior, True),
        'DefaultRootObject': (str, False),
        'Enabled': (boolean, True),
        'HttpVersion': (str, False),
        'IPV6Enabled': (boolean, False),
        'Logging': (Logging, False),
        'Origins': ([Origin], True),
        'PriceClass': (priceclass_type, False),
        'Restrictions': (Restrictions, False),
        'ViewerCertificate': (ViewerCertificate, False),
        'WebACLId': (str, False),
    }


class Distribution(AWSObject):
    resource_type = "AWS::CloudFront::Distribution"

    props = {
        'DistributionConfig': (DistributionConfig, True),
        'Tags': ((Tags, list), False),
    }


class CloudFrontOriginAccessIdentityConfig(AWSProperty):
    props = {
        'Comment': (str, True),
    }


class CloudFrontOriginAccessIdentity(AWSObject):
    resource_type = "AWS::CloudFront::CloudFrontOriginAccessIdentity"

    props = {
        'CloudFrontOriginAccessIdentityConfig': (
            CloudFrontOriginAccessIdentityConfig,
            True,
        ),
    }


class TrustedSigners(AWSProperty):
    props = {
        'AwsAccountNumbers': ([str], False),
        'Enabled': (boolean, True),
    }


class StreamingDistributionConfig(AWSProperty):
    props = {
        'Aliases': ([str], False),
        'Comment': (str, True),
        'Enabled': (boolean, True),
        'Logging': (Logging, False),
        'PriceClass': (priceclass_type, False),
        'S3Origin': (S3Origin, True),
        'TrustedSigners': (TrustedSigners, True),
    }


class StreamingDistribution(AWSObject):
    resource_type = "AWS::CloudFront::StreamingDistribution"

    props = {
        'StreamingDistributionConfig': (StreamingDistributionConfig, True,),
        'Tags': ((Tags, list), False),
    }
